/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.axisgeneration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXGenerate;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.ast.olap.TNodeApplyHeadSuppression;
import com.cognos.xqe.ast.olap.TNodeBuildTagTuple;
import com.cognos.xqe.ast.olap.TNodeHeadCount;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class ConvertCogMDXGroupToMDXGenerate
extends Transformation {
    public ConvertCogMDXGroupToMDXGenerate() {
        this.mName = "Convert CogMDXGroup To MDXGenerate.";
        this.mPassNumbers = new int[]{39};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        CogMDXGroup targetCogMDXGroup = (CogMDXGroup)node;
        boolean injectTags = !targetCogMDXGroup.projectDetailsOnly() && !targetCogMDXGroup.projectNonDetailsOnly() && !targetCogMDXGroup.isEmpty();
        MDXGenerate mdxGenerate = (MDXGenerate)factory.createNode(1057);
        mdxGenerate.setPropertyValue("createFromCogMDXGroup", Boolean.TRUE);
        mdxGenerate.setAll(true);
        mdxGenerate.setAbstractOLAPColumnList(targetCogMDXGroup.getAbstractOLAPColumnList());
        node.getParent().exchangeChildNode(node, mdxGenerate, true);
        MDXHierInfo firstSetHierInfo = ((AbstractMDXSet)mdxGenerate.getChild(0)).getHierarchyInfo();
        MDXHierInfo secondSetHierInfo = ((AbstractMDXSet)mdxGenerate.getChild(1)).getHierarchyInfo();
        if (!secondSetHierInfo.projectsHierarchies(firstSetHierInfo)) {
            IXQEQueryNode mdxSet = factory.createNode(1039);
            firstSetHierInfo.extractHierInfo(secondSetHierInfo);
            mdxSet.addChild(MDXBuilder.buildCurrentMemberTuple(factory, (MDXQuery)node.getAncestorOfType(1002), firstSetHierInfo.getProjectedHierarchies()));
            MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)factory.createNode(1030);
            mdxGenerate.getChild(1).insertParent(mdxCrossjoin);
            mdxCrossjoin.addChild(mdxSet, 0);
        }
        if (injectTags && targetCogMDXGroup.getTagType() == "firstTuple") {
            TNodeBuildTagTuple tNodeBuildTagTuple = (TNodeBuildTagTuple)factory.createNode(1124);
            tNodeBuildTagTuple.setTagType(targetCogMDXGroup.getTagType());
            MDXHierInfo secondSetInfo = ((AbstractMDXSet)mdxGenerate.getChild(1)).getHierarchyInfo();
            for (int i = 0; i < secondSetInfo.getNumProjectedHierarchies(); ++i) {
                tNodeBuildTagTuple.addHierarchy(secondSetInfo.getProjectedHierarchy(i));
            }
            tNodeBuildTagTuple.setCogMDXGroup(targetCogMDXGroup);
            IXQEQueryNode mdxSet = factory.createNode(1039);
            mdxGenerate.insertParent(mdxSet);
            mdxSet.addChild(tNodeBuildTagTuple, 0);
            if (targetCogMDXGroup.getSuppressWhenNoNestedDetails() && mdxGenerate.couldResolveToEmptySet(true, false, false)) {
                IXQEQueryNode tNodeApplyHeadSuppression = factory.createNode(1083);
                TNodeHeadCount tCount = (TNodeHeadCount)factory.createNode(1182);
                ((TNodeApplyHeadSuppression)tNodeApplyHeadSuppression).setTNodeHeadCount(tCount);
                tNodeBuildTagTuple.insertParent(tNodeApplyHeadSuppression);
                tNodeBuildTagTuple.insertParent(factory.createNode(1039));
                mdxGenerate.move(tNodeApplyHeadSuppression);
                MDXQuery mdxQuery = (MDXQuery)mdxGenerate.getAncestorOfType(1002);
                MDXSetAliasReference aliasRef = MDXBuilder.buildMDXSetAlias(factory, mdxQuery, mdxGenerate);
                mdxSet.addChild(aliasRef);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXGroup targetCogMDXGroup = (CogMDXGroup)node;
        IXQEQueryNode[] cogMDXGroups = node.getAncestorsOfType(1027);
        for (int i = 0; i < cogMDXGroups.length; ++i) {
            if (!((CogMDXGroup)cogMDXGroups[i]).isProjectedDescendant(targetCogMDXGroup)) continue;
            Object prepareOuterNestedGroupDiffHierarchyApplied = cogMDXGroups[i].getPropertyValue("PrepareOuterNestedGroupDiffHierarchyApplied");
            Object prepareOuterNestedGroupSameHierarchyApplied = cogMDXGroups[i].getPropertyValue("PrepareOuterNestedGroupSameHierarchyApplied");
            if (prepareOuterNestedGroupDiffHierarchyApplied == Boolean.TRUE || prepareOuterNestedGroupSameHierarchyApplied == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "The target CogMDXGroup node is nested under a CogMDXGroup node that has not yet been transformed by PrepareNestedGroupDifferentHierarchy or PrepareNestedGroupSameHierarchy.", trace);
            return false;
        }
        if (node.getNumberChildren() != 2 || !targetCogMDXGroup.validateChildCategories()) {
            this.traceNodeCondition(false, "The target CogMDXGroup node either does not have 2 operands or the operands are not AbstractMDXSet instances.", trace);
            return false;
        }
        if (((AbstractMDXSet)node.getChild(1)).getDescendantsOfType(1027, true).length > 0 || ((AbstractMDXSet)node.getChild(1)).getDescendantsOfType(1026, true).length > 0) {
            this.traceNodeCondition(false, "The second operand of the target CogMDXGroup node has not been planned yet.", trace);
            return false;
        }
        if (targetCogMDXGroup.getTagType() != null && targetCogMDXGroup.getTagType() != "firstTuple" && targetCogMDXGroup.getTagType() != "eachTuple") {
            this.traceNodeCondition(false, "The target CogMDXGroup node has an unrecognized CogMDXGroup.PROPERTY_TAG_TYPE_REQ property value.", trace);
            return false;
        }
        MDXHierInfo firstSetInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo();
        if (firstSetInfo.getNumProjectedHierarchies() != 1) {
            this.traceNodeCondition(false, "The first AbstractMDXSet operand of the target CogMDXGroup node projects more than one hierarchy.", trace);
            return false;
        }
        MDXHierInfo secondSetInfo = ((AbstractMDXSet)node.getChild(1)).getHierarchyInfo();
        if (firstSetInfo.projectedHierarchiesOverlap(secondSetInfo) && !firstSetInfo.getProjectedHierarchy(0).equals(secondSetInfo.getProjectedHierarchy(0))) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_HierarchyLevelOrderIsBroken, firstSetInfo.getProjectedHierarchy(0).getUniqueName(), targetCogMDXGroup.getRefDataItemProperty());
        }
        this.traceNodeCondition(true, "The second AbstractMDXSet operand is on the same hierarchy projected by the first AbstractMDXSet operand.", trace);
        return true;
    }
}

