/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.axisgeneration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveInnermostEmptyCogMDXGroupForMetadataQuery
extends Transformation {
    public RemoveInnermostEmptyCogMDXGroupForMetadataQuery() {
        this.mName = "Removes an empty innermost CogMDXGroup node when is nested under the same hierarchy";
        this.mPassNumbers = new int[]{34};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        cogMDXGroup.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        String reason = "The transformation is not applicable.";
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        if (cogMDXGroup.getNumberChildren() > 1) {
            this.traceNodeCondition(false, "The transformation is not applicable.", trace);
            return false;
        }
        if (cogMDXGroup.getChild(0).getType() != 1145) {
            this.traceNodeCondition(false, "The transformation is not applicable.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)cogMDXGroup.getAncestorOfCategory(1002);
        if (!mdxQuery.isQueryIntentMetadata()) {
            this.traceNodeCondition(false, "The transformation is not applicable.", trace);
            return false;
        }
        CogMDXGroup ancestorGroup = (CogMDXGroup)cogMDXGroup.getAncestorOfCategory(1027);
        if (ancestorGroup == null) {
            this.traceNodeCondition(false, "The transformation is not applicable.", trace);
            return false;
        }
        if (!ancestorGroup.getFirstSetHierarchy().equals(cogMDXGroup.getFirstSetHierarchy())) {
            this.traceNodeCondition(false, "The transformation is not applicable.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation is applicable.", trace);
        return true;
    }
}

