/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXSetAliasDefinition;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.ast.olap.TNodeApplyHeadSuppression;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import com.cognos.xqe.transformation.olap.util.CalcMemberReferencePrefixes;
import java.util.ArrayList;
import java.util.List;

public class BuildOLAPRowForInnermost
extends Transformation {
    public BuildOLAPRowForInnermost() {
        this.mName = "This transformation builds an OLAPRow node for an innermost CogMDXGroup.";
        this.mPassNumbers = new int[]{35};
        this.mTypes = new int[]{1027, 1080};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        EdgeElementFactory edgeElementFactory = environment.getEdgeElementFactory();
        List<RSAPIDataItem> rsapiDataItemList = cogMDXGroup.getRSAPIDataItemList();
        if (rsapiDataItemList == null) {
            if (BuildXOLAPEdgeMappingUtilities.isDefaultMemberHierNormalizationGroup(cogMDXGroup) || BuildXOLAPEdgeMappingUtilities.isCurrentMemberHierNormalizationGroup(cogMDXGroup) || CalcMemberReferencePrefixes.isNormalizationMeasure(cogMDXGroup.getChild(0)) || CalcMemberReferencePrefixes.isFillerMeasure(cogMDXGroup.getChild(0))) {
                AbstractOLAPColumn column = BuildXOLAPEdgeMappingUtilities.createHierarchyNormalizationOLAPColumn(cogMDXGroup, mdxEdge, edgeElementFactory);
                OLAPRow row = (OLAPRow)edgeElementFactory.createEdgeElementByType(0);
                row.addColumn(column, false);
                cogMDXGroup.setAbstractOLAPRow(row);
                CogMDXGroup ancestorGroup = (CogMDXGroup)cogMDXGroup.getAncestorOfCategory(1027);
                if (ancestorGroup != null && ancestorGroup.isNonDetailGroupBodyValue()) {
                    row.addRemoveAction(edgeElementFactory);
                }
                return;
            }
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "rsapiDataItemList == null");
        }
        for (RSAPIDataItem rsapiDataItem : rsapiDataItemList) {
            IXQEQueryNode setAliasDef;
            IHierarchy hierarchy2;
            OLAPRow row = (OLAPRow)edgeElementFactory.createEdgeElementByType(0);
            int rsapiDataItemPosition = rsapiDataItemList.indexOf(rsapiDataItem);
            BuildXOLAPEdgeMappingUtilities.createAbstractOLAPColumn(2, cogMDXGroup, mdxEdge, edgeElementFactory, rsapiDataItemPosition, rsapiDataItem, (AbstractOLAPRow)row);
            if (cogMDXGroup.getNumberChildren() > 1 && cogMDXGroup.getType() == 1080 && cogMDXGroup.getChild(1).getType() == 1015) {
                AbstractMDXSet setAliasRef = (AbstractMDXSet)cogMDXGroup.getChild(1);
                List<IHierarchy> hierarchies = setAliasRef.getHierarchyInfo().getProjectedHierarchies();
                for (IHierarchy hierarchy2 : hierarchies) {
                    AbstractOLAPColumn column = (AbstractOLAPColumn)edgeElementFactory.createEdgeElementByType(2);
                    column.setHierarchy(hierarchy2);
                    column.addRule(hierarchy2, 0);
                    int aTuplePosition = mdxEdge.getHierarchyInfo().getProjectedHierarchyIndex(hierarchy2);
                    column.setTuplePosition(aTuplePosition);
                    column.setAbstractMDXSetProperties(setAliasRef);
                    row.addColumn(column, true);
                }
            }
            if ((setAliasDef = cogMDXGroup.getAncestorOfCategory(1004)) != null && setAliasDef.getParent().getType() == 1030 && BuildXOLAPEdgeMappingUtilities.isDefaultMemberSet((AbstractMDXSet)setAliasDef.getParent().getChild(1))) {
                AbstractOLAPColumn column = (AbstractOLAPColumn)edgeElementFactory.createEdgeElementByType(2);
                AbstractMDXSet dmSet = (AbstractMDXSet)setAliasDef.getParent().getChild(1);
                hierarchy2 = dmSet.getHierarchyInfo().getProjectedHierarchy(0);
                column.setHierarchy(hierarchy2);
                column.addRule(hierarchy2, 3);
                column.addRemoveAction(edgeElementFactory);
                int aTuplePosition = mdxEdge.getHierarchyInfo().getProjectedHierarchyIndex(hierarchy2);
                column.setTuplePosition(aTuplePosition);
                column.setAbstractMDXSetProperties(dmSet);
                dmSet.setAbstractOLAPColumn(column);
                row.addColumn(column, true);
                continue;
            }
            AbstractMDXSet groupSet = (AbstractMDXSet)cogMDXGroup.getChild(0);
            if (groupSet.getType() != 1039 || groupSet.getChild(0).getType() != 1069 || groupSet.getChild(0).getNumberChildren() != 2 || groupSet.getChild(0).getChild(1).getType() != 1077) continue;
            AbstractOLAPColumn column = (AbstractOLAPColumn)edgeElementFactory.createEdgeElementByType(2);
            hierarchy2 = ((MDXDefaultMember)groupSet.getChild(0).getChild(1)).getHierarchy();
            column.setHierarchy(hierarchy2);
            column.addRule(hierarchy2, 3);
            column.addRemoveAction(edgeElementFactory);
            int aTuplePosition = mdxEdge.getHierarchyInfo().getProjectedHierarchyIndex(hierarchy2);
            column.setTuplePosition(aTuplePosition);
            column.setAbstractMDXSetProperties(groupSet);
            row.addColumn(column, true);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup detailGroup;
        IXQEQueryNode detailExpr;
        MDXCrossjoin mdxCrossjoin;
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        if (mdxEdge == null) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not under a MDXEdge node.", trace);
            return false;
        }
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceQueryCondition(false, "The target's ancestor MDXEdge has not yet an associated XOLAPEdgeMapping.", trace);
            return false;
        }
        if (cogMDXGroup.getAbstractOLAPColumnList() != null) {
            this.traceNodeCondition(false, "This transformation was applied already.", trace);
            return false;
        }
        if (cogMDXGroup.getParent().getType() == 1030 && cogMDXGroup.getParent().getChild(0).getType() == 1027 && cogMDXGroup.getParent().getChild(1).getType() == 1027) {
            this.traceQueryCondition(false, "The target CogMDXGroup is the first child of an MDXCrossjoin.", trace);
            return false;
        }
        if (BuildXOLAPEdgeMappingUtilities.isOrderedNestingMeasures(cogMDXGroup)) {
            this.traceQueryCondition(false, "The target CogMDXGroup is withing an MDXOrder nesting measures.", trace);
            return false;
        }
        if (cogMDXGroup.getNumberChildren() > 1 && (cogMDXGroup.getType() != 1080 || cogMDXGroup.getChild(1).getType() != 1015)) {
            this.traceQueryCondition(false, "The target CogMDXGroup is nesting a set.", trace);
            return false;
        }
        if (mdxEdge != null && !mdxEdge.isProjectedDescendant(cogMDXGroup)) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not projected by its ancestor MDXEdge node.", trace);
            return false;
        }
        if (cogMDXGroup.isRaggedCompensation() && (mdxCrossjoin = (MDXCrossjoin)cogMDXGroup.getAncestorOfType(1030)) != null && ((AbstractMDXSet)mdxCrossjoin.getChild(0)).isProjectedDescendant(cogMDXGroup)) {
            this.traceQueryCondition(false, "The target CogMDXGroup is within a ragged compensation.", trace);
            return false;
        }
        String traceMsg1 = "The detail set for this CogMDXReportSummary has not an AbstractOLAPColumn and an AbstractOLAPRow.";
        if (cogMDXGroup.getType() == 1080 && (detailExpr = ((CogMDXReportSummary)cogMDXGroup).getDetailExpr()) != null && detailExpr.getType() == 1027 && (detailGroup = (CogMDXGroup)((CogMDXReportSummary)cogMDXGroup).getDetailExpr()) != null) {
            AbstractOLAPColumn detailGroupColumn = detailGroup.getFirstAbstractOLAPColumn();
            if (detailGroupColumn == null) {
                IHierarchy detailExprHierarchy = detailGroup.getFirstSetHierarchy();
                List<IXQEQueryNode> nestedGroups = detailGroup.getDescendantsOfCategory(1027, false);
                for (IXQEQueryNode nestedGroup : nestedGroups) {
                    CogMDXGroup nGroup = (CogMDXGroup)nestedGroup;
                    if (!detailExprHierarchy.equals(nGroup.getFirstSetHierarchy()) || !detailGroup.isProjectedDescendant(nGroup)) continue;
                    detailGroupColumn = nGroup.getFirstAbstractOLAPColumn();
                    if (detailGroupColumn != null && detailGroupColumn.doesActionTypeApplies(2)) break;
                    detailGroupColumn = null;
                }
            }
            if (detailGroupColumn == null || detailGroupColumn.getParentRow() == null) {
                this.traceQueryCondition(false, traceMsg1, trace);
                return false;
            }
        }
        if (BuildOLAPRowForInnermost.isSummaryProjectingMultiHierarchyTuple(cogMDXGroup)) {
            this.traceQueryCondition(false, "Target CogMDXGroup projects a tuple of multiple hierarchies", trace);
            return false;
        }
        this.traceNodeCondition(true, "This transformation is applicable.", trace);
        return true;
    }

    public static boolean isSummaryProjectingMultiHierarchyTuple(CogMDXGroup cogMDXGroup) {
        IXQEQueryNode[] tuples;
        if (cogMDXGroup.getType() != 1080) {
            return false;
        }
        boolean isSummaryProjectingMultiHierarchyTuple = false;
        AbstractMDXSet projectedSet = (AbstractMDXSet)cogMDXGroup.getChild(0);
        if (projectedSet.getType() == 1039 && (tuples = projectedSet.getChildrenOfType(1069)).length == projectedSet.getNumberChildren()) {
            for (IXQEQueryNode tupe : tuples) {
                if (tupe.getNumberChildren() <= 1) continue;
                isSummaryProjectingMultiHierarchyTuple = true;
            }
        }
        return isSummaryProjectingMultiHierarchyTuple;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        AbstractMDXSet groupSet = (AbstractMDXSet)cogMDXGroup.getChild(0);
        if (groupSet.getType() == 1145) {
            this.traceNodeCondition(false, "The target CogMDXGroup projects an empty set.", trace);
            return false;
        }
        ArrayList<MDXCalculatedMemberReference> nestedLevelCalculations = new ArrayList<MDXCalculatedMemberReference>();
        IHierarchy hierarchy = cogMDXGroup.getHierarchyInfo().getProjectedHierarchy(0);
        int foundNLC = BuildXOLAPEdgeMappingUtilities.findNestedLevelCalculations(groupSet, nestedLevelCalculations, hierarchy);
        if (foundNLC == 1) {
            this.traceNodeCondition(false, "The target CogMDXGroup projects a nested level calculation.", trace);
            return false;
        }
        if (BuildOLAPRowForInnermost.isNotProjectedWithinHeadSuppression(cogMDXGroup)) {
            this.traceNodeCondition(false, "The target CogMDXGroup is not projected.", trace);
            return false;
        }
        String applicable = "The transformation is applicable.";
        this.traceNodeCondition(true, applicable, trace);
        return true;
    }

    public static boolean isNotProjectedWithinHeadSuppression(CogMDXGroup cogMDXGroup) {
        TNodeApplyHeadSuppression tNodeApplyHeadSuppression = (TNodeApplyHeadSuppression)cogMDXGroup.getAncestorOfType(1083);
        if (tNodeApplyHeadSuppression != null && !tNodeApplyHeadSuppression.isProjectedDescendant(cogMDXGroup)) {
            IXQEQueryNode[] mdxSetAliasDefinitions = cogMDXGroup.getAncestorsOfType(1004);
            if (mdxSetAliasDefinitions == null || mdxSetAliasDefinitions.length == 0) {
                return true;
            }
            for (IXQEQueryNode definition : mdxSetAliasDefinitions) {
                if (definition == null) {
                    return true;
                }
                MDXSetAliasDefinition mdxSetAliasDefinition = (MDXSetAliasDefinition)definition;
                MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
                List<MDXSetAliasReference> setAliasReferences = mdxSetAliasDefinition.getSetAliasRefs();
                for (MDXSetAliasReference setAliasReference : setAliasReferences) {
                    CogMDXReportSummary cogMDXReportSummary;
                    if (!mdxEdge.isProjectedDescendant(setAliasReference) || (cogMDXReportSummary = (CogMDXReportSummary)setAliasReference.getAncestorOfType(1080)) != null && !((AbstractMDXSet)cogMDXReportSummary.getChild(0)).isProjectedDescendant(setAliasReference)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

