/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildOLAPRowForInnermost;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import com.cognos.xqe.transformation.olap.util.CalcMemberReferencePrefixes;
import java.util.List;

public class BuildOLAPRowsForInnermostCrossJoin
extends Transformation {
    private static final String RSAPI_DATA_ITEM_LIST_NULL = "rsapiDataItemList == null";

    public BuildOLAPRowsForInnermostCrossJoin() {
        this.mName = "This transformation builds OLAPRow nodes for an innermost MDXCrossjoin.";
        this.mPassNumbers = new int[]{35};
        this.mTypes = new int[]{1027, 1080};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup cogMDXGroup1 = (CogMDXGroup)node.getParent().getChild(0);
        CogMDXGroup cogMDXGroup2 = (CogMDXGroup)node.getParent().getChild(1);
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup2.getAncestorOfType(1006);
        EdgeElementFactory edgeElementFactory = environment.getEdgeElementFactory();
        List<RSAPIDataItem> rsapiDataItemList1 = cogMDXGroup1.getRSAPIDataItemList();
        AbstractOLAPColumn column1 = null;
        if (rsapiDataItemList1 == null) {
            if (BuildXOLAPEdgeMappingUtilities.isDefaultMemberHierNormalizationGroup(cogMDXGroup2) || CalcMemberReferencePrefixes.isNormalizationMeasure(cogMDXGroup2.getChild(0))) {
                column1 = BuildXOLAPEdgeMappingUtilities.createHierarchyNormalizationOLAPColumn(cogMDXGroup2, mdxEdge, edgeElementFactory);
            }
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, RSAPI_DATA_ITEM_LIST_NULL);
        }
        int rsapiDataItemPosition = 0;
        column1 = BuildXOLAPEdgeMappingUtilities.createAbstractOLAPColumn(2, cogMDXGroup1, mdxEdge, edgeElementFactory, rsapiDataItemPosition, rsapiDataItemList1.get(0), null);
        List<RSAPIDataItem> rsapiDataItemList2 = cogMDXGroup2.getRSAPIDataItemList();
        if (rsapiDataItemList2 == null) {
            OLAPRow row = (OLAPRow)edgeElementFactory.createEdgeElementByType(0);
            if (BuildXOLAPEdgeMappingUtilities.isDefaultMemberHierNormalizationGroup(cogMDXGroup2) || CalcMemberReferencePrefixes.isNormalizationMeasure(cogMDXGroup2.getChild(0))) {
                AbstractOLAPColumn column2 = BuildXOLAPEdgeMappingUtilities.createHierarchyNormalizationOLAPColumn(cogMDXGroup2, mdxEdge, edgeElementFactory);
                row.addColumn(column1, false);
                row.addColumn(column2, true);
                cogMDXGroup2.setAbstractOLAPRow(row);
                CogMDXGroup ancestorGroup = (CogMDXGroup)cogMDXGroup2.getAncestorOfCategory(1027);
                if (ancestorGroup != null && ancestorGroup.isNonDetailGroupBodyValue()) {
                    row.addRemoveAction(edgeElementFactory);
                }
            }
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, RSAPI_DATA_ITEM_LIST_NULL);
        }
        boolean isFirstRow = true;
        for (RSAPIDataItem rsapiDataItem : rsapiDataItemList2) {
            OLAPRow row = (OLAPRow)edgeElementFactory.createEdgeElementByType(0);
            int rsapiDataItemPosition2 = rsapiDataItemList2.indexOf(rsapiDataItem);
            AbstractOLAPColumn column2 = BuildXOLAPEdgeMappingUtilities.createAbstractOLAPColumn(2, cogMDXGroup2, mdxEdge, edgeElementFactory, rsapiDataItemPosition2, rsapiDataItem, null);
            AbstractOLAPColumn firstColumn = column1;
            if (!isFirstRow) {
                firstColumn = (AbstractOLAPColumn)column1.copy(edgeElementFactory, true);
            }
            row.addColumn(firstColumn, false);
            row.addColumn(column2, true);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCrossjoin mdxCrossjoin;
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        if (mdxEdge == null) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not under a MDXEdge node.", trace);
            return false;
        }
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceQueryCondition(false, "The target's ancestor MDXEdge has not yet an associated XOLAPEdgeMapping.", trace);
            return false;
        }
        if (cogMDXGroup.getAbstractOLAPColumnList() != null) {
            this.traceNodeCondition(false, "This transformation was applied already.", trace);
            return false;
        }
        if (cogMDXGroup.getParent().getType() == 1030 && cogMDXGroup.getParent().getChild(0).getType() == 1027 && cogMDXGroup.getParent().getChild(1).getType() == 1027 && (mdxCrossjoin = (MDXCrossjoin)cogMDXGroup.getParent()).getParent().getType() == 1027 && mdxCrossjoin.getParent().getNumberChildren() == 2 && mdxCrossjoin.getParent().getChild(1) == mdxCrossjoin) {
            this.traceQueryCondition(true, "The target CogMDXGroup is the a child of an MDXCrossjoin.", trace);
            return true;
        }
        this.traceNodeCondition(false, "This transformation is not applicable.", trace);
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        AbstractMDXSet groupSet = (AbstractMDXSet)cogMDXGroup.getChild(0);
        if (groupSet.getType() == 1145) {
            this.traceNodeCondition(false, "The target CogMDXGroup projects an empty set.", trace);
            return false;
        }
        if (BuildOLAPRowForInnermost.isNotProjectedWithinHeadSuppression(cogMDXGroup)) {
            this.traceNodeCondition(false, "The target CogMDXGroup is not projected.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation is applicable.", trace);
        return true;
    }
}

