/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;

public class BuildRowForCalculationNestedUnderSameHierarchy
extends Transformation {
    private static final String APPLIED = "BuildRowForCalculationNestedUnderSameHierarchyApplied.";

    public BuildRowForCalculationNestedUnderSameHierarchy() {
        this.mName = "When required this transformation builds an OLAPRow node for an innermost calc CogMDXGroup withing a hirarchy.";
        this.mPassNumbers = new int[]{35};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        XOLAPEdgeMapping xolapEdgeMapping = mdxEdge.getXOLAPEdgeMapping();
        EdgeElementFactory edgeElementFactory = environment.getEdgeElementFactory();
        IHierarchy hierarchy = cogMDXGroup.getFirstSetHierarchy();
        ArrayList<AbstractOLAPColumn> columnList = new ArrayList<AbstractOLAPColumn>();
        columnList.addAll(cogMDXGroup.getAbstractOLAPColumnList());
        for (AbstractOLAPColumn column : columnList) {
            AbstractOLAPRow row = column.getParentRow();
            AbstractOLAPRow rowCopy = (AbstractOLAPRow)row.copy(edgeElementFactory, true);
            OLAPRowCycle newParentRow = null;
            OLAPRowCycle parentRow = (OLAPRowCycle)row.getParentRow();
            while (newParentRow == null) {
                if (!parentRow.getFirstColumn().getHierarchy().equals(hierarchy)) {
                    newParentRow = parentRow;
                    break;
                }
                if ((parentRow = (OLAPRowCycle)parentRow.getParentRow()) != xolapEdgeMapping.getRootRowCycle()) continue;
                newParentRow = parentRow;
            }
            newParentRow.addRow(rowCopy, true);
        }
        cogMDXGroup.setPropertyValue(APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        if (cogMDXGroup.getPropertyValue(APPLIED) != null) {
            this.traceNodeCondition(false, "Trasnformation was applied already.", trace);
            return false;
        }
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        if (mdxEdge == null) {
            this.traceNodeCondition(false, "The target CogMDXGroup is not under a MDXEdge node.", trace);
            return false;
        }
        if (!mdxEdge.getMDXNonEmptyProperty()) {
            this.traceNodeCondition(false, "Non Empty is not applied to the ancestor MDXEdge.", trace);
            return false;
        }
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceNodeCondition(false, "The target's ancestor MDXEdge has not yet an associated XOLAPEdgeMapping.", trace);
            return false;
        }
        String reason = "The target CogMDXGroup is not ready.";
        if (cogMDXGroup.getAbstractOLAPColumnList() == null) {
            this.traceNodeCondition(false, reason, trace);
            return false;
        }
        IHierarchy hierarchy = cogMDXGroup.getFirstSetHierarchy();
        if (mdxEdge != null && !mdxEdge.isProjectedDescendant(cogMDXGroup)) {
            this.traceNodeCondition(false, "The target CogMDXGroup is not projected by its ancestor MDXEdge node.", trace);
            return false;
        }
        AbstractMDXSet groupFirstChild = (AbstractMDXSet)cogMDXGroup.getChild(0);
        if (!groupFirstChild.projectsCalculatedMember()) {
            this.traceNodeCondition(false, "The target CogMDXGroup does not projects calculated members.", trace);
            return false;
        }
        CogMDXGroup ancestorGroup = (CogMDXGroup)cogMDXGroup.getAncestorOfType(1027);
        if (ancestorGroup == null) {
            this.traceNodeCondition(false, "The target CogMDXGroup has no ancestor CogMDXGroup.", trace);
            return false;
        }
        if (!ancestorGroup.getFirstSetHierarchy().equals(hierarchy)) {
            this.traceNodeCondition(false, "Target CogMDXGroup projects a hierarchy different than that projected by its ancestor CogMDXGroup.", trace);
            return false;
        }
        if (cogMDXGroup.getNumberChildren() > 1 && ((AbstractMDXSet)cogMDXGroup.getChild(1)).getHierarchyInfo().getProjectedHierarchy(0).equals(hierarchy)) {
            this.traceNodeCondition(false, "Target CogMDXGroup is not the innermost of its hierarchy.", trace);
            return false;
        }
        if (!((AbstractMDXSet)ancestorGroup.getChild(0)).couldResolveToEmptySet(true, true, true)) {
            this.traceNodeCondition(false, "Ancestor CogMDXGroup could not resolve to empty set.", trace);
            return false;
        }
        XOLAPEdgeMapping xolapEdgeMapping = mdxEdge.getXOLAPEdgeMapping();
        List<AbstractOLAPColumn> columnList = cogMDXGroup.getAbstractOLAPColumnList();
        block0: for (AbstractOLAPColumn column : columnList) {
            AbstractOLAPRow row = column.getParentRow();
            if (row == null || row.getParentRow() == null) {
                this.traceNodeCondition(false, reason, trace);
                return false;
            }
            OLAPRowCycle newParentRow = null;
            OLAPRowCycle parentRow = (OLAPRowCycle)row.getParentRow();
            if (parentRow == xolapEdgeMapping.getRootRowCycle()) {
                this.traceNodeCondition(false, "This transformation is not applicable.", trace);
                return false;
            }
            while (newParentRow == null) {
                if (!parentRow.getFirstColumn().getHierarchy().equals(hierarchy)) {
                    newParentRow = parentRow;
                    continue block0;
                }
                if (parentRow.getParentRow() == null && parentRow != xolapEdgeMapping.getRootRowCycle()) {
                    this.traceNodeCondition(false, reason, trace);
                    return false;
                }
                if ((parentRow = (OLAPRowCycle)parentRow.getParentRow()) == xolapEdgeMapping.getRootRowCycle()) {
                    newParentRow = parentRow;
                    continue block0;
                }
                if (parentRow.getFirstColumn() != null) continue;
                this.traceNodeCondition(false, reason, trace);
                return false;
            }
        }
        this.traceNodeCondition(true, "This transformation is applicable.", trace);
        return true;
    }
}

