/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXHierarchize;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public class BuildRowsForRaggedWhenUsingHierarchize
extends Transformation {
    public static final String REQUIRES_EXTRA_ROWS_FOR_RAGGED = "requiresExtraRowsForRagged";

    public BuildRowsForRaggedWhenUsingHierarchize() {
        this.mName = "This transformation builds AbstractOLAPRow nodes for ragged hierarchies when using MDX HIERARCHIZE.";
        this.mPassNumbers = new int[]{49};
        this.mTypes = new int[]{1037};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        EdgeElementFactory edgeElementFactory = environment.getEdgeElementFactory();
        MDXHierarchize mdxHierarchize = (MDXHierarchize)node;
        List rowCycleList = (List)mdxHierarchize.getPropertyValue(REQUIRES_EXTRA_ROWS_FOR_RAGGED);
        for (OLAPRowCycle rowCycle : rowCycleList) {
            this.createRaggedRows(edgeElementFactory, rowCycle);
        }
        mdxHierarchize.removeProperty(REQUIRES_EXTRA_ROWS_FOR_RAGGED);
    }

    private void createRaggedRows(EdgeElementFactory edgeElementFactory, OLAPRowCycle rowCycle) {
        OLAPRowCycle rowCycleParent = (OLAPRowCycle)rowCycle.getParentRow();
        int numberOfRows = rowCycle.getNumberOfRows();
        for (int i = 0; i < numberOfRows; ++i) {
            AbstractOLAPRow currNestedRow = rowCycle.getRow(i);
            if (!currNestedRow.isCycle() && currNestedRow.getFirstColumn().getRulesType() == 4) continue;
            AbstractOLAPRow rowCopy = (AbstractOLAPRow)currNestedRow.copy(edgeElementFactory, false);
            rowCycleParent.addRow(rowCopy, true);
            if (!currNestedRow.isCycle()) continue;
            this.createRaggedRows(edgeElementFactory, (OLAPRowCycle)currNestedRow);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXHierarchize mdxHierarchize = (MDXHierarchize)node;
        List rowCycleList = (List)mdxHierarchize.getPropertyValue(REQUIRES_EXTRA_ROWS_FOR_RAGGED);
        if (rowCycleList == null || rowCycleList.isEmpty()) {
            this.traceNodeCondition(false, "This transformation is not applicable.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This transformation is applicable.", trace);
        return true;
    }
}

