/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.trace.XQETrace;

public class CleanDeletedEdgeMappingRuleMemberDescriptors
extends Transformation {
    private static final String EDGE_MAPPING_RULE_MEMBER_DESCRIPTORS_CLEANED = "EdgeMappingRuleMemberDescriptorsCleaned";

    public CleanDeletedEdgeMappingRuleMemberDescriptors() {
        this.mName = "Removes EdgeMappingRules MemberDescriptor objects flagged as deleted.";
        this.mPassNumbers = new int[]{49};
        this.mTypes = new int[]{1006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge mdxEdge = (MDXEdge)node;
        XOLAPEdgeMapping xOLAPEdgeMapping = mdxEdge.getXOLAPEdgeMapping();
        xOLAPEdgeMapping.cleanDeletedMemberDescriptors();
        mdxEdge.setPropertyValue(EDGE_MAPPING_RULE_MEMBER_DESCRIPTORS_CLEANED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXEdge mdxEdge = (MDXEdge)node;
        String transformationDoesNotApplies = "The transfromation does not applies.";
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceNodeCondition(false, "The transfromation does not applies.", trace);
            return false;
        }
        if (mdxEdge.getPropertyValue(EDGE_MAPPING_RULE_MEMBER_DESCRIPTORS_CLEANED) != null) {
            this.traceNodeCondition(false, "The transfromation does not applies.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transfromation does applies.", trace);
        return true;
    }
}

