/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXHierarchize;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;

public class FixOLAPEdgeElementsForHierarchize
extends Transformation {
    public FixOLAPEdgeElementsForHierarchize() {
        this.mName = "This transformation fixes the AbstractOLAPEdgeElement affected by ReplaceGenerateWithHierarchize.";
        this.mPassNumbers = new int[]{49};
        this.mTypes = new int[]{1037};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        EdgeElementFactory edgeElementFactory = environment.getEdgeElementFactory();
        MDXHierarchize mdxHierarchize = (MDXHierarchize)node;
        ArrayList<AbstractOLAPColumn> abstractOLAPColumnList = new ArrayList<AbstractOLAPColumn>();
        abstractOLAPColumnList.addAll(mdxHierarchize.getAbstractOLAPColumnList());
        mdxHierarchize.setAbstractOLAPColumnList(null);
        ArrayList<OLAPRowCycle> rowCycleList = new ArrayList<OLAPRowCycle>();
        for (AbstractOLAPColumn currOLAPColumn : abstractOLAPColumnList) {
            OLAPContextColumn currContextColumn = (OLAPContextColumn)currOLAPColumn;
            IHierarchy hierarchy = currContextColumn.getHierarchy();
            OLAPRowCycle currRowCycle = (OLAPRowCycle)currContextColumn.getParentRow();
            rowCycleList.add(currRowCycle);
            ArrayList<AbstractOLAPRow> innerMostRows = new ArrayList<AbstractOLAPRow>();
            this.getInnerMostRowsForHierarchy(currRowCycle, hierarchy, innerMostRows);
            this.replaceFillerTagRowsForHierarchy(edgeElementFactory, hierarchy, currRowCycle, innerMostRows);
        }
        if (!rowCycleList.isEmpty()) {
            mdxHierarchize.setPropertyValue("requiresExtraRowsForRagged", rowCycleList);
        }
    }

    private void replaceFillerTagRowsForHierarchy(EdgeElementFactory edgeElementFactory, IHierarchy hierarchy, OLAPRowCycle topRowCycle, List<AbstractOLAPRow> innerMostRows) {
        ArrayList<AbstractOLAPRow> fillerTagRows = new ArrayList<AbstractOLAPRow>();
        this.getFillerTagRowsForHierarchy(topRowCycle, hierarchy, fillerTagRows);
        for (AbstractOLAPRow fillerTagRow : fillerTagRows) {
            int currIndex = -1;
            OLAPRowCycle parentRowCycle = (OLAPRowCycle)fillerTagRow.getParentRow();
            boolean fixLinkSuppression = false;
            ArrayList<AbstractOLAPRow> innerMostRowsCpies = new ArrayList<AbstractOLAPRow>();
            for (AbstractOLAPRow currInnerMostRow : innerMostRows) {
                AbstractOLAPRow currInnerMostRowCpy = (AbstractOLAPRow)currInnerMostRow.copy(edgeElementFactory, true);
                innerMostRowsCpies.add(currInnerMostRowCpy);
                currInnerMostRowCpy.addRemoveAction(edgeElementFactory);
                currInnerMostRowCpy.setHierarchyNormalization(true);
                fixLinkSuppression = !fixLinkSuppression && currInnerMostRowCpy.getRowsLinkedToThis() != null;
                currInnerMostRowCpy.setFillerTagRow(-1);
                if (!currInnerMostRow.isCycle() && currInnerMostRow.getFirstColumn().getHierarchy().equals(hierarchy)) {
                    AbstractOLAPColumn currentMemberColumnCpy = (AbstractOLAPColumn)fillerTagRow.getFirstColumn().copy(edgeElementFactory, true);
                    currInnerMostRowCpy.insertColumn(currentMemberColumnCpy, currInnerMostRowCpy.getFirstColumn().getTuplePosition());
                }
                if (currIndex == -1) {
                    currIndex = parentRowCycle.replaceRow(fillerTagRow, currInnerMostRowCpy);
                    continue;
                }
                parentRowCycle.insertRow(currInnerMostRowCpy, ++currIndex);
            }
            if (!fixLinkSuppression) continue;
            for (AbstractOLAPRow currInnerMostRowCpy2 : innerMostRowsCpies) {
                if (currInnerMostRowCpy2.getRowsLinkedToThis() == null) continue;
                currInnerMostRowCpy2.getRowsLinkedToThis().clear();
            }
            for (AbstractOLAPRow currInnerMostRowCpy1 : innerMostRowsCpies) {
                if (!currInnerMostRowCpy1.doesActionTypeApplies(3)) continue;
                for (AbstractOLAPRow currInnerMostRowCpy2 : innerMostRowsCpies) {
                    if (currInnerMostRowCpy2.getRowsLinkedToThis() == null) continue;
                    currInnerMostRowCpy2.addRowLinkedToThis(currInnerMostRowCpy1);
                }
            }
        }
    }

    private void getInnerMostRowsForHierarchy(OLAPRowCycle rowCycle, IHierarchy hierarchy, List<AbstractOLAPRow> innerMostRows) {
        int numberOfRows = rowCycle.getNumberOfRows();
        for (int i = 0; i < numberOfRows; ++i) {
            AbstractOLAPRow currNestedRow = rowCycle.getRow(i);
            if (currNestedRow.isFillerTagRow() != 0) continue;
            if (!currNestedRow.isCycle()) {
                innerMostRows.add(currNestedRow);
                continue;
            }
            if (((OLAPRowCycle)currNestedRow).getFirstColumn().getHierarchy().equals(hierarchy)) {
                this.getInnerMostRowsForHierarchy((OLAPRowCycle)currNestedRow, hierarchy, innerMostRows);
                continue;
            }
            innerMostRows.add(currNestedRow);
        }
    }

    private void getFillerTagRowsForHierarchy(OLAPRowCycle rowCycle, IHierarchy hierarchy, List<AbstractOLAPRow> fillerTagRows) {
        int numberOfRows = rowCycle.getNumberOfRows();
        for (int i = 0; i < numberOfRows; ++i) {
            AbstractOLAPRow currNestedRow = rowCycle.getRow(i);
            if (currNestedRow.isFillerTagRow() == 1) {
                if (!currNestedRow.getFirstColumn().getHierarchy().equals(hierarchy)) continue;
                fillerTagRows.add(currNestedRow);
                continue;
            }
            if (!currNestedRow.isCycle() || !((OLAPRowCycle)currNestedRow).getFirstColumn().getHierarchy().equals(hierarchy)) continue;
            this.getFillerTagRowsForHierarchy((OLAPRowCycle)currNestedRow, hierarchy, fillerTagRows);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXHierarchize mdxHierarchize = (MDXHierarchize)node;
        if (mdxHierarchize.getAbstractOLAPColumnList() == null) {
            this.traceNodeCondition(false, "This transformation is not required.", trace);
            return false;
        }
        boolean result = this.checkAncestorCrossjoin(mdxHierarchize);
        if (result) {
            this.traceNodeCondition(true, "The transformation is applicable.", trace);
        } else {
            this.traceNodeCondition(false, "The transformation is not applicable.", trace);
        }
        return result;
    }

    private boolean checkAncestorCrossjoin(MDXHierarchize mdxHierarchize) {
        IXQEQueryNode[] nestedHierarchizeList;
        IXQEQueryNode mdxCrossjoin = mdxHierarchize.getAncestorOfType(1030);
        if (mdxCrossjoin == null) {
            return true;
        }
        for (IXQEQueryNode nestedHierarchize : nestedHierarchizeList = mdxCrossjoin.getDescendantsOfType(1037, false)) {
            MDXHierarchize currHierarchize;
            if (nestedHierarchize == mdxHierarchize || (currHierarchize = (MDXHierarchize)nestedHierarchize).getAbstractOLAPColumnList() == null) continue;
            return false;
        }
        return this.checkCrossjoin(mdxCrossjoin);
    }

    private boolean checkCrossjoin(IXQEQueryNode mdxCrossjoin1) {
        IXQEQueryNode[] nestedNamedSetList;
        for (IXQEQueryNode nestedNamedSet : nestedNamedSetList = mdxCrossjoin1.getDescendantsOfType(1014, true)) {
            IXQEQueryNode[] nestedCrossjoinList;
            IXQEQueryNode[] nestedHierarchizeList;
            MDXNamedSetDefinition currNamedSetDef = ((MDXNamedSetReference)nestedNamedSet).getDefinition();
            for (IXQEQueryNode nestedHierarchize : nestedHierarchizeList = currNamedSetDef.getDescendantsOfType(1037, false)) {
                MDXHierarchize currHierarchize = (MDXHierarchize)nestedHierarchize;
                if (currHierarchize.getAbstractOLAPColumnList() == null) continue;
                return false;
            }
            for (IXQEQueryNode mdxCrossjoin2 : nestedCrossjoinList = currNamedSetDef.getDescendantsOfType(1030, false)) {
                for (IXQEQueryNode nestedHierarchize : nestedHierarchizeList = mdxCrossjoin2.getDescendantsOfType(1037, false)) {
                    MDXHierarchize currHierarchize = (MDXHierarchize)nestedHierarchize;
                    if (currHierarchize.getAbstractOLAPColumnList() == null) continue;
                    return false;
                }
                if (this.checkCrossjoin(mdxCrossjoin2)) continue;
                return false;
            }
        }
        return true;
    }
}

