/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;

public class RebuildMUNRulesForPowerCubeRootAliases
extends ProviderTransformation {
    public static final String REBUILD_MUNRULES_FOR_PC_ROOTALIASES = "RebuildMUNRulesForPowerCubeRootAliasesApplied";

    public RebuildMUNRulesForPowerCubeRootAliases() {
        super(new String[]{"PC"});
        this.mName = "Rebuilds the MUN rules for power cube root aliases.";
        this.mPassNumbers = new int[]{36};
        this.mTypes = new int[]{1006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge mdxEdge = (MDXEdge)node;
        mdxEdge.getXOLAPEdgeMapping().rebuildMUNRulesForPowerCubeRootAliases();
        mdxEdge.setPropertyValue(REBUILD_MUNRULES_FOR_PC_ROOTALIASES, Boolean.TRUE);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXEdge mdxEdge = (MDXEdge)node;
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceNodeCondition(false, "The target MDXEdge has no XOLAPEdgeMapping.", trace);
            return false;
        }
        if (mdxEdge.getPropertyValue(REBUILD_MUNRULES_FOR_PC_ROOTALIASES) == Boolean.TRUE) {
            this.traceNodeCondition(false, "This transformation was applied already.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This transformation has not been applied yet.", trace);
        return true;
    }
}

