/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.OLAPEmptyRowDecoration;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.trace.XQETrace;

public class RemoveDecorationRuntreeNodes
extends Transformation {
    public RemoveDecorationRuntreeNodes() {
        this.mName = "Remove decoration nodes from run tree.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{501144};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean foundDeco = RemoveDecorationRuntreeNodes.removeDecorationRuntreeNodes(node);
        if (!foundDeco) {
            environment.setTreeHasBeenModified();
        }
    }

    public static boolean removeDecorationRuntreeNodes(IXQEQueryNode node) {
        IXQEQueryNode parent;
        boolean foundDeco = false;
        for (parent = node.getParent(); parent != null && parent.isOfCategory(601008); parent = parent.getParent()) {
            foundDeco = true;
            if ((parent.getType() != 601012 || ((OLAPEmptyRowDecoration)parent).getSubType() != 101053 && ((OLAPEmptyRowDecoration)parent).getSubType() != 101052) && parent.getType() != 601018) continue;
        }
        if (foundDeco) {
            node.detach();
            parent.exchangeChildNode(parent.getChild(0), node);
        }
        while (parent != null && parent.isOfCategory(601008)) {
            if (parent.getType() == 601012 && (((OLAPEmptyRowDecoration)parent).getSubType() == 101053 || ((OLAPEmptyRowDecoration)parent).getSubType() == 101052)) {
                parent = parent.getParent();
                continue;
            }
            if (parent.getType() == 601018) {
                parent = parent.getParent();
                continue;
            }
            IXQEQueryNode tmpParent = parent;
            parent = parent.getParent();
            tmpParent.extract();
        }
        foundDeco = false;
        IXQEQueryNode child = node.getChild(0);
        while (child.getType() == 501144) {
            child = child.getChild(0);
        }
        return foundDeco;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        XOLAPEdgeMapping xOLAPEdgeMapping = (XOLAPEdgeMapping)node;
        if (xOLAPEdgeMapping.getParent().getType() != 501144) {
            this.traceNodeCondition(true, "The target XOLAPEdgeMapping is not nested under other XOLAPEdgeMapping.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The target XOLAPEdgeMapping is nested under other XOLAPEdgeMapping.", trace);
        return false;
    }
}

