/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.trace.XQETrace;

public class ReplaceWithHUNRules
extends Transformation {
    public ReplaceWithHUNRules() {
        this.mName = "Any type of rules could be replaced with HUN rules when the edge projects a single set of base members.";
        this.mPassNumbers = new int[]{53};
        this.mTypes = new int[]{501144};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XOLAPEdgeMapping xOLAPEdgeMapping = (XOLAPEdgeMapping)node;
        AbstractOLAPRow row = xOLAPEdgeMapping.getRootRowCycle().getRow(0);
        for (int i = 0; i < row.getNumberOfColumns(); ++i) {
            AbstractOLAPColumn currColumn = row.getColumn(i);
            if (currColumn.getRulesType() == 0 || currColumn.getNumOfCalculations() != 0) continue;
            row.getColumn(i).getRules().replaceWithHUNRules();
        }
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((XOLAPEdgeMapping)node).getRootRowCycle() != null && ((XOLAPEdgeMapping)node).getRootRowCycle().getNumberOfRows() == 1 && !((XOLAPEdgeMapping)node).getRootRowCycle().getRow(0).isCycle()) {
            AbstractOLAPRow row = ((XOLAPEdgeMapping)node).getRootRowCycle().getRow(0);
            for (int i = 0; i < row.getNumberOfColumns(); ++i) {
                AbstractOLAPColumn currColumn = row.getColumn(i);
                if (currColumn.getRulesType() == 0 || currColumn.getNumOfCalculations() != 0) continue;
                this.traceNodeCondition(true, "Tranformation is applicable.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "Tranformation is not applicable.", trace);
        return false;
    }
}

