/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.finalization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.HashMap;
import java.util.List;

public class SetQueryNamedSetNameToExpandedDefinitionMap
extends Transformation {
    public static final String QUERY_NAMED_SET_NAME_TO_EXPANDED_DEFINITION_MAP = "queryNamedSetNameToExpandedDefinition";

    public SetQueryNamedSetNameToExpandedDefinitionMap() {
        this.mName = "Set the query named set name to expanded defintion map.";
        this.mPassNumbers = new int[]{53};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        HashMap<String, String> strMap = new HashMap<String, String>();
        MDXQuery mdxQuery = (MDXQuery)node;
        IXQEQueryNode[] defininitions = mdxQuery.getChildrenOfType(1003);
        int[] parameterNodeTypes = new int[]{1163, 1162, 1129, 1161, 1159};
        for (IXQEQueryNode def : defininitions) {
            MDXNamedSetDefinition namedSetDef = (MDXNamedSetDefinition)def;
            IXQEQueryNode definition = this.getExpandedDefinition(factory, namedSetDef);
            if (definition == null || !definition.getDescendantsOfTypeOrdered(1013, false).isEmpty() || definition.getDescendantsOfTypes(parameterNodeTypes, false).length > 0) continue;
            StringBuilder buffer = new StringBuilder();
            definition.writeFormattedText(buffer);
            strMap.put(namedSetDef.getUniqueName(), buffer.toString());
        }
        mdxQuery.setPropertyValue(QUERY_NAMED_SET_NAME_TO_EXPANDED_DEFINITION_MAP, strMap);
    }

    public IXQEQueryNode getExpandedDefinition(IXQENodeFactory factory, MDXNamedSetDefinition namedSetDef) {
        IXQEQueryNode def = this.getRecursiveExpandedDefinition(factory, namedSetDef);
        IHierarchy hierarchy = null;
        List<IXQEQueryNode> calcs = def.getDescendantsOfTypeOrdered(1013, false);
        while (!calcs.isEmpty()) {
            MDXCalculatedMemberReference calcRef;
            for (IXQEQueryNode calc : calcs) {
                calcRef = (MDXCalculatedMemberReference)calc;
                if (hierarchy == null) {
                    hierarchy = calcRef.getHierarchy();
                    continue;
                }
                if (hierarchy.equals(calcRef.getHierarchy())) continue;
                return null;
            }
            for (IXQEQueryNode calc : calcs) {
                calcRef = (MDXCalculatedMemberReference)calc;
                IXQEQueryNode calcDef = calcRef.getDefinition().getChild(0);
                IXQEQueryNode copyCalcDef = MDXBuilder.deepCopyExcludingCMDefs(factory, (AbstractMDXNode)calcDef, false);
                calcRef.exchange(copyCalcDef);
                IXQEQueryNode parent = copyCalcDef.getParent();
                BaseHierarchy mdxHierarchy = MDXBuilder.buildMDXBaseHierarchyExpr(factory, hierarchy);
                parent.addChildAfterNode(mdxHierarchy, copyCalcDef);
            }
            calcs = def.getDescendantsOfTypeOrdered(1013, false);
        }
        return def;
    }

    public IXQEQueryNode getRecursiveExpandedDefinition(IXQENodeFactory factory, MDXNamedSetDefinition namedSetDef) {
        IXQEQueryNode def = MDXBuilder.deepCopyExcludingCMDefs(factory, (AbstractMDXNode)namedSetDef.getChild(0), false);
        List<IXQEQueryNode> references = def.getDescendantsOfTypeOrdered(1014, false);
        for (IXQEQueryNode ref : references) {
            IXQEQueryNode expandedDef = this.getRecursiveExpandedDefinition(factory, ((MDXNamedSetReference)ref).getDefinition());
            ref.exchange(expandedDef);
        }
        return def;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(QUERY_NAMED_SET_NAME_TO_EXPANDED_DEFINITION_MAP) != null) {
            this.traceQueryCondition(false, "The named set map has already been added.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node;
        if (!mdxQuery.getCapabilities().isSupported("mdx.support.namedSetCaching")) {
            this.traceQueryCondition(false, "The provider does not support named set caching.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The named set map can be created.", trace);
        return true;
    }
}

