/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.intersecting_wds;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.intersecting_wds.IntersectingWDSUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public final class FindIntersectingWDSCalcs
extends Transformation {
    public FindIntersectingWDSCalcs() {
        this.mName = "Merge Intersecting WDS Calculations.";
        this.mPassNumbers = new int[]{27};
        this.mTypes = new int[]{1013};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        MDXCalculatedMemberDefinition calcDef = calcRef.getDefinition();
        List<MDXCalculatedMemberReference> intWDSCalcs = IntersectingWDSUtil.getSimpleProjectedLowerSOWDSCalcsOnOtherEdge(calcRef);
        List<MDXCalculatedMemberReference> mergeCalcs = IntersectingWDSUtil.filterCalcsThatRequireMerging(calcRef, intWDSCalcs);
        IXQEQueryNode tNodeIntersectingWDSCalcs = factory.createNode(1119);
        AbstractMDXValueExpression calcDefExpr = (AbstractMDXValueExpression)calcDef.getChild(0);
        calcDefExpr.insertParent(tNodeIntersectingWDSCalcs);
        tNodeIntersectingWDSCalcs.addChild(factory.deepCopyNode(calcDefExpr));
        for (int i = 0; i < mergeCalcs.size(); ++i) {
            MDXCalculatedMemberReference interCalcRef = mergeCalcs.get(i);
            MDXCalculatedMemberReference copyRef = (MDXCalculatedMemberReference)factory.createNode(1013);
            copyRef.bind(interCalcRef.getDefinition());
            tNodeIntersectingWDSCalcs.addChild(copyRef);
            tNodeIntersectingWDSCalcs.addChild(factory.deepCopyNode(interCalcRef.getDefinition().getChild(0)));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        if (edge == null || !((AbstractMDXSet)edge.getChild(0)).isProjectedDescendant(calcRef)) {
            this.traceNodeCondition(false, "The calculated member is not projected on the edge.", trace);
            return false;
        }
        if (calcRef.isAlternateMeasureRef()) {
            this.traceNodeCondition(false, "The calculated member is an alternate measure.", trace);
            return false;
        }
        if (!IntersectingWDSUtil.isWithinDetailCalc(calcRef)) {
            this.traceNodeCondition(false, "The calculated member is not a within detail calc.", trace);
            return false;
        }
        List<MDXCalculatedMemberReference> intWDSCalcs = IntersectingWDSUtil.getSimpleProjectedLowerSOWDSCalcsOnOtherEdge(calcRef);
        if (intWDSCalcs.isEmpty()) {
            this.traceNodeCondition(false, "There does not exist an intersecting within detail summaries on another edge with a lower solve order.", trace);
            return false;
        }
        List<MDXCalculatedMemberReference> mergeCalcs = IntersectingWDSUtil.filterCalcsThatRequireMerging(calcRef, intWDSCalcs);
        if (mergeCalcs.isEmpty()) {
            this.traceNodeCondition(false, "All intersecting within detail summaries on another edge with a lower solve order are alternate measures or are associative summaries of the same type.", trace);
            return false;
        }
        calcRef.getDefinition().throwOnInvalidChildCategories();
        this.traceNodeCondition(true, "There exists an intersecting within detail summary on another edge with a lower solve order.", trace);
        return true;
    }
}

