/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.intersecting_wds;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.v5.V5ResultCellUpdate;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.v5.cellupdate.AbstractXV5CellUpdateRule;
import com.cognos.xqe.runtree.v5.cellupdate.XV5CellSpec;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.intersecting_wds.IntersectingWDSUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public final class InsertErrorCellUpdateIntersectingWDSCalcs
extends Transformation {
    public InsertErrorCellUpdateIntersectingWDSCalcs() {
        this.mName = "Insert Error cell decoration for intersecting within details calcs when lower solve order calc is complex.";
        this.mPassNumbers = new int[]{23};
        this.mTypes = new int[]{1013};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        MDXCalculatedMemberDefinition calcDef = calcRef.getDefinition();
        List<MDXCalculatedMemberReference> intWDSCalcs = IntersectingWDSUtil.getUnsupportedProjectedLowerSOWDSCalcsOnOtherEdge(calcRef);
        for (int i = 0; i < intWDSCalcs.size(); ++i) {
            MDXCalculatedMemberReference interCalcRef = intWDSCalcs.get(i);
            InsertErrorCellUpdateIntersectingWDSCalcs.createIntersectingSOWDSErrorCellDecoration(calcRef, interCalcRef, environment);
            MDXCalculatedMemberDefinition interCalcDef = interCalcRef.getDefinition();
            int aSeverity = 1;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_IntersectingWithinDetailCalc, interCalcDef.getV5Caption(), calcDef.getV5Caption()));
        }
    }

    public static void createIntersectingSOWDSErrorCellDecoration(MDXCalculatedMemberReference calcRef, MDXCalculatedMemberReference interCalcRef, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)calcRef.getAncestorOfType(1002);
        RSAPIDataset rsapiDataset = (RSAPIDataset)mdxQuery.getAncestorOfType(401005);
        V5ResultCellUpdate cellUpdateNode = null;
        IXQEQueryNode[] nodeCellUpdate = rsapiDataset.getDescendantsOfType(601014, false);
        if (nodeCellUpdate.length == 0) {
            cellUpdateNode = (V5ResultCellUpdate)nodeFactory.createNode(601014);
            rsapiDataset.getChild(0).insertParent(cellUpdateNode);
        } else {
            cellUpdateNode = (V5ResultCellUpdate)nodeCellUpdate[0];
            environment.setTreeHasBeenModified();
        }
        MDXEdge mdEdge = (MDXEdge)interCalcRef.getAncestorOfType(1006);
        int currentEdgeOrdinal = mdxQuery.getEdgeOrdinal(mdEdge);
        CogMDXGroup interCalcGroup = (CogMDXGroup)interCalcRef.getAncestorOfCategory(1027);
        RSAPIEdgeRowset rowset = interCalcGroup.getRSAPIEdgeRowset();
        int rowSetId = rowset.getRowsetId();
        int dataItemOrdinal = rowset.getDataItemOrdinal(interCalcGroup.getFirstRSAPIDataItem());
        XV5CellSpec cm1CellSpec = new XV5CellSpec(currentEdgeOrdinal, rowSetId, dataItemOrdinal, null);
        AbstractXV5CellUpdateRule cellUpdateRule = new AbstractXV5CellUpdateRule(cm1CellSpec){

            @Override
            public boolean apply(ICell cell) {
                Value v = null;
                IValue column = cell.getValue();
                if (column instanceof ContextValue) {
                    ContextValue cv = (ContextValue)column;
                    v = (Value)cv.getValue().copy();
                    cv.setValue(v);
                } else {
                    v = (Value)column.copy();
                    cell.setValue(v);
                }
                v.setState(ValueState.ERROR);
                return true;
            }
        };
        CogMDXGroup calcRefGroup = (CogMDXGroup)calcRef.getAncestorOfCategory(1027);
        mdEdge = (MDXEdge)calcRef.getAncestorOfType(1006);
        currentEdgeOrdinal = mdxQuery.getEdgeOrdinal(mdEdge);
        rowset = calcRefGroup.getRSAPIEdgeRowset();
        rowSetId = rowset.getRowsetId();
        dataItemOrdinal = rowset.getDataItemOrdinal(calcRefGroup.getFirstRSAPIDataItem());
        XV5CellSpec cm2CellSpec = new XV5CellSpec(currentEdgeOrdinal, rowSetId, dataItemOrdinal, null);
        cellUpdateRule.addIntersectingCellSpec(cm2CellSpec);
        cellUpdateNode.addCellUpdateRule(cellUpdateRule);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        if (edge == null || !((AbstractMDXSet)edge.getChild(0)).isProjectedDescendant(calcRef)) {
            this.traceNodeCondition(false, "The calculated member is not projected on the edge.", trace);
            return false;
        }
        if (!IntersectingWDSUtil.isWithinDetailCalc(calcRef)) {
            this.traceNodeCondition(false, "The calculated member is not a within detail calc.", trace);
            return false;
        }
        List<MDXCalculatedMemberReference> intWDSCalcs = IntersectingWDSUtil.getUnsupportedProjectedLowerSOWDSCalcsOnOtherEdge(calcRef);
        if (intWDSCalcs.isEmpty()) {
            this.traceNodeCondition(false, "There is no complex intersecting within detail summary on another edge with a lower solve order.", trace);
            return false;
        }
        calcRef.getDefinition().throwOnInvalidChildCategories();
        this.traceNodeCondition(true, "There exists an intersecting complex within detail summary on another edge with a lower solve order.", trace);
        return true;
    }
}

