/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.list;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXNest;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public final class ConvertCogMDXNestNodesToCogMDXGroupNodes
extends Transformation {
    public ConvertCogMDXNestNodesToCogMDXGroupNodes() {
        this.mName = "Convert CogMDXNest Nodes To CogMDXGroup Nodes.";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{1026};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXNest cogMDXNest = (CogMDXNest)node;
        CogMDXGroup cogMDXGroup = (CogMDXGroup)nodeFactory.createNode(1027);
        cogMDXGroup.setPropertyValue("refDataItem", cogMDXNest.getPropertyValue("refDataItem"));
        cogMDXGroup.setRSAPIDataItemList(cogMDXNest.getRSAPIDataItemList());
        cogMDXGroup.setRSAPIEdgeRowset(cogMDXNest.getRSAPIEdgeRowset());
        cogMDXGroup.setDataItemIndexesProjectingSameSet(cogMDXNest.getDataItemIndexesProjectingSameSet());
        String propName = "nestingDepthOfContextForProperty";
        if (cogMDXNest.getPropertyValue("nestingDepthOfContextForProperty") != null) {
            cogMDXGroup.setPropertyValue("nestingDepthOfContextForProperty", cogMDXNest.getPropertyValue("nestingDepthOfContextForProperty"));
        }
        cogMDXGroup.setContextNames(cogMDXNest.getContextNames());
        CogMDXReportSummary.updateRefSummary(cogMDXNest, cogMDXGroup);
        cogMDXNest.getParent().exchangeChildNode(cogMDXNest, cogMDXGroup, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getAncestorOfType(1026) != null) {
            this.traceNodeCondition(false, "The CogMDXNest node is a descendant of another CogMDXNest node which must be converted to a CogMDXGroup node before this transformation can be applied.", trace);
            return false;
        }
        IXQEQueryNode[] descendatNests = node.getDescendantsOfType(1026, false);
        if (descendatNests.length == 0) {
            this.traceNodeCondition(true, "A single CogMDXNest node is equivalent to a CogMDXGroup node.", trace);
            return true;
        }
        if (!((CogMDXNest)node).validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the CogMDXNest node are invalid.", trace);
            return false;
        }
        MDXHierInfo hierInfo = ((CogMDXNest)node).getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() > 0 && hierInfo.getProjectedHierarchy(0).getDimension().isMeasuresDimension()) {
            this.traceNodeCondition(false, "The CogMDXNest node projects the measure dimension.", trace);
            return false;
        }
        AbstractMDXSet projset = (AbstractMDXSet)node.getChild(0);
        MDXLevelInfo levelInfo = projset.getLevelInfo();
        IHierarchy hierarchy = levelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        levelInfo.removeCalculationLevels();
        if (!levelInfo.projectsLevels() && projset.projectsCalculatedMember() && !projset.projectsNonCalculatedMember()) {
            for (IXQEQueryNode descendatNest : descendatNests) {
                AbstractMDXSet nestedProjset = (AbstractMDXSet)descendatNest.getChild(0);
                if (!nestedProjset.projectsCalculatedMember() || nestedProjset.projectsNonCalculatedMember() || !nestedProjset.getHierarchyInfo().projectsHierarchy(hierarchy)) continue;
                String dataItem1 = ((CogMDXNest)node).getRefDataItemProperty();
                String dataItem2 = ((CogMDXNest)descendatNest).getRefDataItemProperty();
                MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedNonMeasureCalcDetailColumns, mdxQuery.getV5NameProperty(), (Object)hierarchy.getCaption(), (Object)dataItem1, (Object)dataItem2);
            }
        }
        this.traceNodeCondition(true, "The transformation can be applied to this node.", trace);
        return true;
    }
}

