/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.TNodeApplyHeadSuppression;
import com.cognos.xqe.ast.olap.TNodeHeadCount;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.nestedlevelcalculation.Util;

public final class ConvertTNodeHeadCountToNumber
extends Transformation {
    public ConvertTNodeHeadCountToNumber() {
        this.mName = "Convert TNodeHeadCount to numeric value.";
        this.mPassNumbers = new int[]{39};
        this.mTypes = new int[]{1083};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int numberOfProjectedTuples = 0;
        TNodeHeadCount headCount = ((TNodeApplyHeadSuppression)node).getTNodeHeadCount();
        if (node.getChild(0).getType() == 1039) {
            AbstractMDXSet childSet = (AbstractMDXSet)node.getChild(0);
            numberOfProjectedTuples = childSet.getNumberOfProjectedTuples();
            if (this.projectsNestedLevelCalculation(childSet)) {
                numberOfProjectedTuples *= 2;
            }
            headCount.setConstantValue(numberOfProjectedTuples);
        }
        headCount.setBeenConverted(true);
    }

    private boolean projectsNestedLevelCalculation(IXQEQueryNode childSet) {
        IXQEQueryNode[] calcRefs;
        StringBuilder sb = new StringBuilder();
        for (IXQEQueryNode calcRef : calcRefs = childSet.getChild(0).getDescendantsOfType(1013, true)) {
            if (!Util.isNestedLevelCalculation((MDXCalculatedMemberReference)calcRef, sb)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        TNodeHeadCount headCount = ((TNodeApplyHeadSuppression)node).getTNodeHeadCount();
        if (headCount == null || headCount.getIsConverted()) {
            this.traceNodeCondition(false, " Invalid head count or TNodeHeadCount already been converted", trace);
            return false;
        }
        if (node.getParent() != null && !node.getParent().isOfCategory(1021)) {
            this.traceNodeCondition(false, "Invalid parent for TNodeApplyHeadSuppression", trace);
            return false;
        }
        this.traceNodeCondition(true, "TNodeHeadCount is valid.", trace);
        return true;
    }
}

