/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXCurrentMember;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class ReplaceMDXCurrentMemberInValueExpressionTuples
extends Transformation {
    public ReplaceMDXCurrentMemberInValueExpressionTuples() {
        this.mName = "Replace MDXCurrentMember In Value Expression Tuples";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1076};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXHierInfo contextHierInfo = ((MDXCurrentMember)node).getContextHierarchyInfo();
        IXQEQueryNode parent = node.getParent();
        node.detach();
        parent.addChild(MDXBuilder.buildMDXCurrentMemberExpr(factory, contextHierInfo.getProjectedHierarchy(0)));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The target MDXCurrentMember node has invalid child nodes.", trace);
            return false;
        }
        if (node.getParent().isOfCategory(1068) && ((MDXTuple)node.getParent()).isValueExpressionOperand()) {
            if (node.getParent().getNumberChildren() == 1) {
                MDXHierInfo hierInfo = ((MDXCurrentMember)node).getHierarchyInfo();
                MDXHierInfo contextHierInfo = ((MDXCurrentMember)node).getContextHierarchyInfo();
                if (contextHierInfo.getNumProjectedHierarchies() > 0 && !contextHierInfo.projectsHierarchy(hierInfo.getProjectedHierarchy(0))) {
                    this.traceNodeCondition(true, "The target MDXCurrentMember node should be replaced with an MDXCurrentMember expression on one of the hierarchies in context.", trace);
                    return true;
                }
            }
            this.traceNodeCondition(false, "The target MDXCurrentMember node is a child of an MDXTuple node with multiple child nodes.  RemoveMDXCurrentMemberFromValueExpressionTuples should be applied to the target node before this transformation.", trace);
            return false;
        }
        this.traceNodeCondition(false, "The target MDXCurrentMember node is not used in a value expression context.", trace);
        return false;
    }
}

