/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.RemoveEdge;
import com.cognos.xqe.ast.localprocessing.v5.V5MasterDetailWindow;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXNull;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.NodeConditions.IsProjectedDescendant;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import java.util.ArrayList;

public final class AppendNullProjectedMeasure
extends Transformation {
    private static final String TRACE_1 = "There are";
    private static final String TRACE_2 = "some MDXEdge children under the given MDXQuery node.";
    private static final String TRACE_3 = "projected measures.";

    public AppendNullProjectedMeasure() {
        this.mName = "Append a new MDXEdge node projecting a single null measure when there are no other measures or a count projected.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXEdge mdxEdge = (MDXEdge)nodeFactory.createNode(1006);
        node.addChild(mdxEdge);
        MDXEdge[] mdxEdges = ((MDXQuery)node).getEdges();
        for (int i = 0; i < mdxEdges.length; ++i) {
            mdxEdges[i].setMDXNonEmptyProperty(Boolean.FALSE);
            mdxEdges[i].setPowerCubeZeroSuppress(Boolean.FALSE);
        }
        int solveOrder = SolveOrderUtil.getMaxMDXSolveOrder();
        boolean includeSelf = false;
        ArrayList<IXQEQueryNode> calcRefs = new ArrayList<IXQEQueryNode>();
        MDXQuery mdxQuery = (MDXQuery)node;
        IsProjectedDescendant isProjCalcRef = new IsProjectedDescendant(mdxQuery);
        int[] nodeTypes = new int[]{1013};
        isProjCalcRef.setNodeTypes(nodeTypes);
        mdxQuery.getDescendantsForCondition(calcRefs, isProjCalcRef, includeSelf);
        AbstractMDXMember calcRef = this.createDummyDMRMeasureAvoidCrossJoin(nodeFactory, (MDXQuery)node, mdxEdges[0]);
        if (calcRef == null) {
            calcRef = MDXBuilder.buildMDXCalculatedMemberReference(nodeFactory, (MDXQuery)node, ((MDXQuery)node).getMeasuresHierarchy(), "_NULL", (MDXNull)nodeFactory.createNode(1089), solveOrder);
        }
        MDXSet mdxSet = MDXBuilder.buildMDXSetExpr((IXQENodeFactory)nodeFactory, calcRef);
        mdxEdge.addChild(mdxSet);
        RemoveEdge removeEdge = (RemoveEdge)nodeFactory.createNode(601011);
        IXQEQueryNode parentDeco = node.getAncestorOfCategory(601008);
        IXQEQueryNode lastFound = node;
        int[] breakTypes = new int[]{401005, 501039};
        while (parentDeco != null && !(lastFound = parentDeco).getParent().isOfTypes(breakTypes)) {
            parentDeco = lastFound.getAncestorOfCategory(601007);
        }
        lastFound.insertParent(removeEdge);
        int edgeOrdinal = ((MDXQuery)node).getEdgeOrdinal(mdxEdge);
        removeEdge.setEdgeOrdinal(edgeOrdinal);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode ancestorNode = node.getAncestorOfType(601026);
        if (ancestorNode != null) {
            boolean status;
            V5MasterDetailWindow mdw = (V5MasterDetailWindow)ancestorNode;
            boolean bl = status = mdw.getMasterDetailWindowNodeIDMaster() == mdw.getId().intValue();
            if (status) {
                this.traceQueryCondition(false, "The optimization is not required for this master query replaced later one.", trace);
                return false;
            }
        }
        this.traceQueryCondition(true, "The query is not the master query of a query using single MDX Query.", trace);
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery;
        IHierarchy hierarchy;
        XQETrace trace = environment.getTrace();
        StringBuilder msgStr = null;
        if (trace.getTraceLevel() != 0) {
            msgStr = new StringBuilder();
        }
        if ((hierarchy = (mdxQuery = (MDXQuery)node).getMDXFrom().getCube().getMeasuresHierarchy()) == null) {
            this.traceNodeCondition(false, "The cube has no measure/fact, optimization is not applicable.", trace);
            return false;
        }
        MDXEdge[] mdxEdges = mdxQuery.getEdges();
        boolean status = mdxEdges.length != 0;
        boolean foundMetadata = false;
        if (status) {
            int i;
            if (msgStr != null) {
                msgStr.append(TRACE_1);
                msgStr.append(" ");
                msgStr.append(TRACE_2);
            }
            if (mdxQuery.isSuppressNulls() && mdxQuery.isAtLeastOneEdgeSuppressed()) {
                this.traceNodeCondition(false, "Null suppression is required for the MDX query, based on default measure.", trace);
                return false;
            }
            for (i = 0; i < mdxEdges.length; ++i) {
                MDXEdge mdxEdge = mdxEdges[i];
                if (mdxEdge.getHierarchyInfo().getNumProjectedHierarchies() != 0 && !((AbstractMDXSet)mdxEdge.getChild(0)).isEmpty()) {
                    foundMetadata = true;
                }
                MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
                if (mdxEdge.getHierarchyInfo().projectsMeasures() || dimLine != null && dimLine.getHierarchyInfo().projectsMeasures()) break;
                boolean includeSelf = false;
                IXQEQueryNode[] calcMemberRefs = mdxEdge.getDescendantsOfType(1013, includeSelf);
                for (int j = 0; j < calcMemberRefs.length; ++j) {
                    boolean isFooterOrHeader;
                    MDXCalculatedMemberReference calcMemberRef = (MDXCalculatedMemberReference)calcMemberRefs[j];
                    RSAPIEdgeRowset rowSet = calcMemberRef.getRSAPIEdgeRowset();
                    boolean bl = isFooterOrHeader = mdxEdge.isProjectedDescendant(calcMemberRef) && rowSet != null && (rowSet.isFooterRowset() || rowSet.isHeaderRowset());
                    if (!isFooterOrHeader) continue;
                    this.traceNodeCondition(false, "Query contains a projected header or footer.", trace);
                    return false;
                }
            }
            boolean bl = status = i == mdxEdges.length;
            if (status) {
                if (msgStr != null) {
                    msgStr.append(" ");
                    msgStr.append(TRACE_1);
                    msgStr.append(" ");
                    msgStr.append("not");
                    msgStr.append(" ");
                    msgStr.append(TRACE_3);
                }
                if ((status = foundMetadata) && msgStr != null) {
                    msgStr.append(" ");
                    msgStr.append("No hierarchy is projected.");
                }
            } else if (msgStr != null) {
                msgStr.append(TRACE_1);
                msgStr.append(" ");
                msgStr.append(TRACE_3);
            }
        } else if (msgStr != null) {
            msgStr.append(TRACE_1);
            msgStr.append(" ");
            msgStr.append("not");
            msgStr.append(" ");
            msgStr.append(TRACE_2);
        }
        if (msgStr != null) {
            this.traceNodeCondition(status, msgStr.toString(), trace);
        }
        return status;
    }

    protected AbstractMDXMember createDummyDMRMeasureAvoidCrossJoin(IXQENodeFactory nodeFactory, MDXQuery mdxQuery, MDXEdge edge) {
        if (!mdxQuery.isDMR()) {
            return null;
        }
        if (mdxQuery.isRelationaCrosstab()) {
            return null;
        }
        CubeWrapper cube = (CubeWrapper)mdxQuery.getMDXFrom().getCube();
        if (cube.getTabStreamWrapper() != null) {
            return null;
        }
        if (cube.getModelDataSource().isDummy() || cube.getV5QuerySetForV5Source() != null) {
            return null;
        }
        if (!mdxQuery.getInvolvedMeasures().isEmpty()) {
            return null;
        }
        IDataSource dataSource = mdxQuery.getMDXFrom().getCMDataSource();
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        int stitchingLevels = capabilities.getIntegerValue("stitchMultiHierLevelsForReportWithoutMeasure", 0);
        if (stitchingLevels != 1 && stitchingLevels != 2) {
            return null;
        }
        MDXHierInfo hier = mdxQuery.getHierarchyInfo();
        if (hier.getNumProjectedHierarchies() < 2) {
            return null;
        }
        if (!mdxQuery.isListReport()) {
            return null;
        }
        IMember dummy = TabStreamUtil.getOrCreateDummyMeasure(nodeFactory, cube, stitchingLevels);
        AbstractMDXMember newNode = (AbstractMDXMember)nodeFactory.createNode(1067);
        ((BaseMember)newNode).bind(dummy);
        edge.setMDXNonEmptyProperty(Boolean.TRUE);
        return newNode;
    }
}

