/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class CacheHierarchyInformation
extends Transformation {
    public CacheHierarchyInformation() {
        this.mName = "Cache hierarchy information.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge[] edges;
        MDXQuery mdxQuery = (MDXQuery)node;
        for (MDXEdge edge : edges = mdxQuery.getEdges()) {
            edge.setReferencedHierarchies(edge.getReferencedHierarchies());
        }
        mdxQuery.setReferencedHierarchies(mdxQuery.getReferencedHierarchies());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        if (node.getPropertyValue("referencedHierarchies") != null) {
            this.traceQueryCondition(false, "The MDXQuery hierarchy information has already been cached.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The MDXQuery node has valid child categories and can cache hierarchy information.", trace);
        return true;
    }
}

