/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCustomValue;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXPushdownQueryDefinition;
import com.cognos.xqe.ast.olap.MDXPushdownQueryReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXStringConstant;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.dmr.DMRPushdownQueryGenerator;
import com.cognos.xqe.transformation.olap.optimization.PushSetEvaluationToDataSourceAsCustomSet;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.pushdownQuery.DMRCustomValueRefiner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PushCalculatedMemberExpressionToDataSourceAsCustomValue
extends Transformation {
    public static final String PROP_CUSTOM_VALUE_PUSHDOWN = "customValuePushDown";
    public static final String PROP_CUSTOM_VALUE_REFINER = "customValueRefiner";
    private static final int[] CONSTS = new int[]{1064, 1089, 1127, 1151};

    public PushCalculatedMemberExpressionToDataSourceAsCustomValue() {
        this.mName = "Push the summary function over a large member set to underlying data source.";
        this.mPassNumbers = new int[]{48};
        this.mTypes = new int[]{1195};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (this.generateCustomValueForFactDriven(node, environment)) {
            return;
        }
        try {
            IXQEQueryNode[] namedSet;
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
            ArrayList<DMRPushdownQueryGenerator.ContextDataItem> contextDataItemNames = new ArrayList<DMRPushdownQueryGenerator.ContextDataItem>();
            ArrayList<DMRPushdownQueryGenerator.ContextDataItem> ancestorDataItemNames = new ArrayList<DMRPushdownQueryGenerator.ContextDataItem>();
            AbstractMDXNode pushdownTarget = (AbstractMDXNode)node;
            DMRPushdownQueryGenerator g = new DMRPushdownQueryGenerator(environment, false);
            V5QuerySet querySet = g.buildEmptyQuerySet("PushdownQuery", PushSetEvaluationToDataSourceAsCustomSet.getModelLocale(environment, pushdownTarget.getLevelInfo()));
            querySet.setPropertyValue(PROP_CUSTOM_VALUE_PUSHDOWN, true);
            DMRCustomValueRefiner cvRefiner = new DMRCustomValueRefiner(querySet, environment, false);
            querySet.setPropertyValue(PROP_CUSTOM_VALUE_REFINER, cvRefiner);
            HashSet<IHierarchy> explicitHier = new HashSet<IHierarchy>();
            String contextInfo = this.collectContextInfo(pushdownTarget, explicitHier);
            MDXLevelInfo contextLevelInfo = pushdownTarget.getContextLevelInfo();
            this.projectLevels(environment, querySet, contextLevelInfo, contextDataItemNames, null, explicitHier, true);
            StringBuilder buffer = new StringBuilder();
            g.visit(pushdownTarget, querySet, contextDataItemNames, ancestorDataItemNames, buffer);
            DMRCustomValueRefiner refiner = DMRPushdownQueryGenerator.getCustomValueRefiner(querySet);
            refiner.refine();
            MDXPushdownQueryDefinition pushdownQuery = (MDXPushdownQueryDefinition)nodeFactory.createNode(1189);
            mdxQuery.addChild(pushdownQuery);
            pushdownQuery.setPushdownQuery(querySet);
            pushdownQuery.setUniqueName("XQE_PUSHDOWNQUERY" + mdxQuery.getNextPushdownQueryId());
            MDXPushdownQueryReference pushdownQueryRef = (MDXPushdownQueryReference)nodeFactory.createNode(1190);
            pushdownQueryRef.bind(pushdownQuery);
            MDXStringConstant contextIndependentFlag = (MDXStringConstant)nodeFactory.createNode(1127);
            contextIndependentFlag.setConstantValue(contextInfo);
            MDXCustomValue customValue = (MDXCustomValue)nodeFactory.createNode(1196);
            customValue.addChild(pushdownQueryRef);
            customValue.addChild(contextIndependentFlag);
            node.getChild(0).exchange(customValue);
            node.extract();
            for (IXQEQueryNode aNamedSet : namedSet = mdxQuery.getChildrenOfType(1003)) {
                if (mdxQuery.isSetSpecificationReferenced((MDXNamedSetDefinition)aNamedSet)) continue;
                aNamedSet.detach();
            }
        }
        catch (Exception e) {
            node.getParent().setPropertyValue("local_process_only", Boolean.TRUE);
            node.extract();
        }
    }

    private String collectContextInfo(AbstractMDXNode pushdownTarget, HashSet<IHierarchy> hs) {
        IXQEQueryNode tp;
        StringBuilder sb = new StringBuilder();
        sb.append("<c v='true'>");
        int tuplePos = 1;
        if (pushdownTarget.getType() == 1041) {
            tuplePos = 2;
        } else if (pushdownTarget.getType() == 1195) {
            tuplePos = 0;
        }
        IXQEQueryNode v = pushdownTarget.getChild(tuplePos);
        if (pushdownTarget.getType() == 1053) {
            IXQEQueryNode[] children = v.getChildren();
            v = null;
            if (children.length == 1) {
                v = children[0];
            } else if (children.length == 2) {
                if (children[1].isOfTypes(CONSTS)) {
                    v = children[0];
                } else if (children[0].isOfTypes(CONSTS)) {
                    v = children[1];
                }
            }
        }
        if (v != null && v.getType() == 1059 && v.getNumberChildren() == 1 && (tp = v.getChild(0)).getType() == 1069) {
            IXQEQueryNode[] members;
            for (IXQEQueryNode mb : members = tp.getChildren()) {
                MDXDefaultMember aDefaultMb;
                IHierarchy tmp;
                IHierarchy h = null;
                int type = mb.getType();
                if (type == 1067) {
                    BaseMember aMb = (BaseMember)mb;
                    tmp = aMb.getHierarchy();
                    if (!tmp.getDimension().isMeasuresDimension() && aMb.getLevel().isRootLevel()) {
                        h = tmp;
                    }
                } else if (type == 1077 && !(tmp = (aDefaultMb = (MDXDefaultMember)mb).getHierarchy()).getDimension().isMeasuresDimension()) {
                    h = tmp;
                }
                if (h == null) continue;
                hs.add(h);
                sb.append("<hierarchy name='");
                sb.append(h.getUniqueName());
                sb.append("' />");
            }
        }
        sb.append("</c>");
        return sb.toString();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        return true;
    }

    private static boolean isDummyDimension(IDimension dim) {
        String dimName = dim.getName();
        return dimName.equals("dummy") || dimName.equals("secondDummy") || dimName.equals("tagDimension");
    }

    private void projectLevels(PlanningEnvironment environment, V5QuerySet querySet, MDXLevelInfo projectedLevelInfo, List<DMRPushdownQueryGenerator.ContextDataItem> resultDataItemList, List<ILevel> outputLevels, HashSet<IHierarchy> explicitHier, boolean addInQRD) {
        DMRPushdownQueryGenerator g = new DMRPushdownQueryGenerator(environment, false);
        for (IHierarchy hierarchy : projectedLevelInfo.getHierarchyInfo().getProjectedHierarchies()) {
            if (hierarchy.getDimension().isMeasuresDimension() || PushCalculatedMemberExpressionToDataSourceAsCustomValue.isDummyDimension(hierarchy.getDimension()) || projectedLevelInfo.getProjectedLevels(hierarchy).isEmpty() || explicitHier.contains(hierarchy)) continue;
            ILevel level = projectedLevelInfo.getLowestProjectedLevelsSkipCalculation(hierarchy);
            level = ((MDXLevelInfo.LevelInfo)level).getLevel();
            if (outputLevels != null && level instanceof LevelWrapper) {
                outputLevels.add(level);
            }
            ArrayList<ILevel> ancestorLevels = new ArrayList<ILevel>();
            while (!level.isRootLevel()) {
                ancestorLevels.add(0, level);
                level = level.getPreviousLevel();
            }
            for (ILevel aLevel : ancestorLevels) {
                resultDataItemList.add(g.addLevelToV5QuerySet((LevelWrapper)aLevel, addInQRD, querySet));
            }
        }
    }

    private boolean generateCustomValueForFactDriven(IXQEQueryNode node, PlanningEnvironment environment) {
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR");
        if (providerCapabilities == null) {
            return false;
        }
        String singleLoading = providerCapabilities.getStringValue("enablePreLoadCubeWithSingleSubQuery", "true");
        String cellFetch = providerCapabilities.getStringValue("CellFetchingAfterPreloading", "PreciseLoad");
        if (!"auto".equals(singleLoading) || !"NoLoad".equals(cellFetch)) {
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() != 1005) {
            return false;
        }
        MDXCalculatedMemberDefinition mdxCalc = (MDXCalculatedMemberDefinition)parent;
        IHierarchy hier = mdxCalc.getHierarchy();
        if (hier == null || !hier.getDimension().isMeasuresDimension()) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        ICube cube = mdxQuery.getReferencedCube();
        if (!(cube instanceof CubeWrapper)) {
            return false;
        }
        CubeWrapper cubeWrapper = (CubeWrapper)cube;
        String[] parts = UniqueNameParser.parseNoThrow(mdxCalc.getUniqueName());
        if (parts == null) {
            return false;
        }
        if (cubeWrapper.getGovernors().getSuppress() == Governors.Suppress.NONE) {
            return false;
        }
        if (mdxQuery.isDMRCubeReuseEnabled()) {
            return false;
        }
        int last = parts.length - 1;
        parts[last] = parts[last] + "_FactDrivenMDXCustomValue";
        IXQEQueryNode tnode = node.detach();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXPushdownQueryDefinition pushdownQuery = (MDXPushdownQueryDefinition)nodeFactory.createNode(1189);
        mdxQuery.addChild(pushdownQuery);
        pushdownQuery.setUniqueName(UniqueNameGenerator.createUniqueName(parts));
        MDXPushdownQueryReference pushdownQueryRef = (MDXPushdownQueryReference)nodeFactory.createNode(1190);
        pushdownQueryRef.bind(pushdownQuery);
        MDXCustomValue customValue = (MDXCustomValue)nodeFactory.createNode(1196);
        customValue.addChild(pushdownQueryRef);
        MDXStringConstant contextIndependentFlag = (MDXStringConstant)nodeFactory.createNode(1127);
        contextIndependentFlag.setConstantValue(parts[last]);
        customValue.addChild(contextIndependentFlag);
        parent.addChild(customValue);
        cubeWrapper.addMeasureForCustomValue(parts[last], tnode);
        return true;
    }
}

