/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.v5.V5SuppressRule;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveLocalSuppressionForUnSupportedCellype
extends Transformation {
    public RemoveLocalSuppressionForUnSupportedCellype() {
        this.mName = "Remove Local Suppression based on cell type a provider cannot return.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode localSuppresion = node.getAncestorOfType(601022);
        MDXQuery mdxQuery = (MDXQuery)node;
        MDXFromCube mdxFrom = mdxQuery.getMDXFrom();
        boolean returnDivByZeroCell = mdxFrom.isProviderReturnDivByZeroCell();
        boolean returnOverflowCell = mdxFrom.isProviderReturnOverflowCell();
        for (int idx = 1; idx < localSuppresion.getNumberChildren(); ++idx) {
            V5SuppressRule suppressRule = (V5SuppressRule)localSuppresion.getChild(idx);
            if (suppressRule.getDivByZero() && !returnDivByZeroCell) {
                suppressRule.setDivByZero(false);
            }
            if (suppressRule.getOverflow() && !returnOverflowCell) {
                suppressRule.setOverflow(false);
            }
            if (suppressRule.getOverflow() || suppressRule.getDivByZero() || suppressRule.getNulls() || suppressRule.getZero()) continue;
            suppressRule.removeSubtreeDefinition();
        }
        if (localSuppresion.getNumberChildren() == 1) {
            localSuppresion.extract();
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode localSuppresion = node.getAncestorOfType(601022);
        if (localSuppresion == null) {
            this.traceQueryCondition(false, "No local suppression applied to this MDX Query.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node;
        MDXFromCube mdxFrom = mdxQuery.getMDXFrom();
        boolean returnDivByZeroCell = mdxFrom.isProviderReturnDivByZeroCell();
        boolean returnOverflowCell = mdxFrom.isProviderReturnOverflowCell();
        for (int idx = 1; idx < localSuppresion.getNumberChildren(); ++idx) {
            V5SuppressRule suppressRule = (V5SuppressRule)localSuppresion.getChild(idx);
            if (suppressRule.getDivByZero() && !returnDivByZeroCell) {
                this.traceQueryCondition(true, "Local suppression on divByZero and provider cannot return this cell type.", trace);
                return true;
            }
            if (!suppressRule.getOverflow() || returnOverflowCell) continue;
            this.traceQueryCondition(true, "Local suppression on Overflow and provider cannot return this cell type.", trace);
            return true;
        }
        this.traceQueryCondition(false, "No local suppression on not supported cell type found.", trace);
        return false;
    }

    @Override
    public void dumpSpecificationReferences(XQETrace trace) {
        String element = "element";
        trace.beginElement("specification", -1);
        trace.attribute("type", "schema");
        trace.attribute("category", element);
        trace.attribute(element, "edgeSuppression");
        trace.endElement();
    }
}

