/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class RemoveMDXOrderOrHierarchizeWhenNotRequired
extends Transformation {
    private int[] validIntermediateOpTypes = new int[]{1030, 1033, 1032, 1053, 1057, 1037, 1038, 1058, 1039};

    public RemoveMDXOrderOrHierarchizeWhenNotRequired(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Remove MDX ordering set expression when not the set driving the final order.";
        this.mTypes = new int[]{1058, 1037};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode firstChild = node.detachChild(0);
        node.getParent().exchangeChildNode(node, firstChild, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (this.isDescendantOfSummaryWithNoInvalidIntermediateNodes(node)) {
            this.traceQueryCondition(true, "The operation supplied by the target node is not required due to the outer MDXSummaryFunction/Count node.", trace);
            return true;
        }
        if (this.isDescendantOfHierarchizeWithNoInvalidIntermediateNodes(node)) {
            this.traceQueryCondition(true, "The operation supplied by the target node is not required due to the outer MDXHierarchize node.", trace);
            return true;
        }
        if (this.isSecondDescendantOfIntersectOrExceptWithNoInvalidIntermediateNodes(node)) {
            this.traceQueryCondition(true, "The operation supplied by the target node is not required due to the outer MDXIntersect/Except node.", trace);
            return true;
        }
        IXQEQueryNode mdxNSDef = node.getAncestorOfType(1003);
        if (mdxNSDef != null) {
            IXQEQueryNode parent;
            for (parent = node.getParent(); parent != mdxNSDef && parent.isOfCategories(this.validIntermediateOpTypes); parent = parent.getParent()) {
            }
            if (parent == mdxNSDef) {
                MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
                IXQEQueryNode[] mdxNSRefs = mdxQuery.getDescendantsOfType(1014, false);
                for (int i = 0; i < mdxNSRefs.length; ++i) {
                    if (((MDXNamedSetReference)mdxNSRefs[i]).getDefinition() != mdxNSDef || this.isDescendantOfSummaryWithNoInvalidIntermediateNodes(mdxNSRefs[i]) || this.isDescendantOfHierarchizeWithNoInvalidIntermediateNodes(mdxNSRefs[i]) || this.isSecondDescendantOfIntersectOrExceptWithNoInvalidIntermediateNodes(mdxNSRefs[i])) continue;
                    return false;
                }
                return true;
            }
        }
        this.traceQueryCondition(false, "This optimization is not valid for the target node.", trace);
        return false;
    }

    private boolean isDescendantOfSummaryWithNoInvalidIntermediateNodes(IXQEQueryNode node) {
        int[] summaryTypes = new int[]{1060, 1087};
        IXQEQueryNode mdxSummary = node.getAncestorOfTypes(summaryTypes);
        if (mdxSummary != null) {
            IXQEQueryNode parent;
            for (parent = node.getParent(); parent != mdxSummary && parent.isOfCategories(this.validIntermediateOpTypes); parent = parent.getParent()) {
            }
            if (parent == mdxSummary) {
                return true;
            }
        }
        return false;
    }

    private boolean isDescendantOfHierarchizeWithNoInvalidIntermediateNodes(IXQEQueryNode node) {
        IXQEQueryNode mdxHierarchize = node.getAncestorOfType(1037);
        if (mdxHierarchize != null) {
            IXQEQueryNode parent;
            for (parent = node.getParent(); parent != mdxHierarchize && parent.isOfCategories(this.validIntermediateOpTypes); parent = parent.getParent()) {
            }
            if (parent == mdxHierarchize) {
                return true;
            }
        }
        return false;
    }

    private boolean isSecondDescendantOfIntersectOrExceptWithNoInvalidIntermediateNodes(IXQEQueryNode node) {
        if (node.isDescendantOfChildAtIndexForNodeOfType(1038, 1, true) || node.isDescendantOfChildAtIndexForNodeOfType(1032, 1, true)) {
            IXQEQueryNode child = node;
            IXQEQueryNode parent = node.getParent();
            while (parent.getType() != 1038 || parent.getPositionOfChild(child) != 1) {
                child = parent;
                if ((parent = parent.getParent()) != null) continue;
                return false;
            }
            IXQEQueryNode mdxIntersect = parent;
            for (parent = node.getParent(); parent != mdxIntersect && parent.isOfCategories(this.validIntermediateOpTypes); parent = parent.getParent()) {
            }
            if (parent == mdxIntersect) {
                return true;
            }
        }
        return false;
    }
}

