/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXOrder;
import com.cognos.xqe.ast.olap.MDXTopBottomFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveRedundantOrderOnTopBottomFn
extends Transformation {
    private static final int THREE = 3;

    public RemoveRedundantOrderOnTopBottomFn() {
        this.mName = "Optimize Order On Topcounts.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1041};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getParent().getType() == 1037) {
            node.getParent().extract();
        }
        node.getParent().detachChild(1);
        node.getParent().extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXOrder order = null;
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 1058) {
            order = (MDXOrder)parent;
        } else if (parent.getType() == 1037 && parent.getParent().getType() == 1058) {
            order = (MDXOrder)parent.getParent();
        } else {
            this.traceNodeCondition(false, "Cannot find an order function.", trace);
            return false;
        }
        if (node.getNumberChildren() < 3) {
            this.traceNodeCondition(false, "The topbottom function has less than three children.", trace);
            return false;
        }
        if (order.getNumberChildren() < 2) {
            this.traceNodeCondition(false, "The order function has less than two children.", trace);
            return false;
        }
        if (!node.getChild(2).isSameExpression(order.getChild(1), false)) {
            this.traceNodeCondition(false, "The value expressions are not the same.", trace);
            return false;
        }
        MDXTopBottomFunction topBottom = (MDXTopBottomFunction)node;
        int type = topBottom.getOperatorType();
        if (type == 1 || type == 3 || type == 2) {
            if (order.getOrderingProperty() == 3) {
                this.traceNodeCondition(true, "The order on the top function is redundant and can be removed.", trace);
                return true;
            }
        } else if (order.getOrderingProperty() == 1) {
            this.traceNodeCondition(true, "The order on the bottom function is redundant and can be removed.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The order cannot be removed.", trace);
        return false;
    }
}

