/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXGenerate;
import com.cognos.xqe.ast.olap.MDXHierarchize;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSetAliasDefinition;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.optimization.PushExpressionEvaluationToDatabase;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class ReplaceContextIndependentSetWithNamedSet
extends Transformation {
    public ReplaceContextIndependentSetWithNamedSet() {
        this.mName = "Replace Context Independent Set With Named Set";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1044, 1045, 1048, 1030, 1052, 1033, 1032, 1106, 1053, 1057, 1042, 1037, 1038, 1074, 1058, 1075, 1051, 1090, 1041, 1039};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode parent = node.getParent();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        AbstractMDXNode target = (AbstractMDXNode)node;
        if (dimLine != null && dimLine.getChild(0).getType() == 1069) {
            MDXTuple dimTuple = (MDXTuple)dimLine.getChild(0);
            boolean memberAdded = false;
            for (IXQEQueryNode child : dimTuple.getChildren()) {
                AbstractMDXMember member = (AbstractMDXMember)child;
                IHierarchy hierarchy = member.getHierarchyInfo().getProjectedHierarchy(0);
                if (!target.isContextDependent(hierarchy)) continue;
                if (member.isOfCategory(1013)) {
                    ((MDXCalculatedMemberReference)member).setCopyDefinition(false);
                }
                target.addMemberToContext(factory, member, true);
                memberAdded = true;
            }
            if (memberAdded) {
                MDXBuilder.buildMDXNamedSetAndReplaceIt(factory, mdxQuery, "", (AbstractMDXNode)node, (AbstractMDXNode)parent);
                return;
            }
        }
        IXQEQueryNode[] namedSetDefs = mdxQuery.getChildrenOfType(1003);
        for (int i = 0; i < namedSetDefs.length; ++i) {
            ((MDXNamedSetDefinition)namedSetDefs[i]).throwOnInvalidChildCategories();
            IXQEQueryNode nodeDef = namedSetDefs[i].getChild(0);
            if (!node.isSameExpression(nodeDef, false)) continue;
            MDXNamedSetReference namedSetReference = (MDXNamedSetReference)factory.createNode(1014);
            namedSetReference.bind((MDXNamedSetDefinition)namedSetDefs[i]);
            if (nodeDef.getType() == 1037) {
                MDXHierarchize targetSet = (MDXHierarchize)target;
                MDXHierarchize previousSet = (MDXHierarchize)nodeDef;
                List<AbstractOLAPColumn> columnList = previousSet.getAbstractOLAPColumnList();
                if (columnList != null && targetSet.getAbstractOLAPColumnList() != null) {
                    columnList.addAll(targetSet.getAbstractOLAPColumnList());
                } else if (columnList == null && targetSet.getAbstractOLAPColumnList() != null) {
                    columnList = targetSet.getAbstractOLAPColumnList();
                }
                previousSet.setAbstractOLAPColumnList(columnList);
            }
            this.cleanSetAliasReference(mdxQuery, node, (MDXNamedSetDefinition)namedSetDefs[i]);
            if (parent.getType() == 1004) {
                for (MDXSetAliasReference ref : ((MDXSetAliasDefinition)parent).getSetAliasRefs()) {
                    ref.exchange(factory.deepCopyNode(namedSetReference), true);
                }
                IXQEQueryNode setAliasDefinition = parent;
                parent = setAliasDefinition.getParent();
                setAliasDefinition.extract();
            }
            parent.exchangeChildNode(node, namedSetReference, false);
            return;
        }
        MDXBuilder.buildMDXNamedSetAndReplaceIt(factory, mdxQuery, "", (AbstractMDXNode)node, (AbstractMDXNode)parent);
    }

    protected void cleanSetAliasReference(MDXQuery mdxQuery, IXQEQueryNode node, MDXNamedSetDefinition namedSetDef) {
        IXQEQueryNode[] srcAliasDefs = node.getDescendantsOfType(1004, false);
        if (srcAliasDefs == null || srcAliasDefs.length < 1) {
            return;
        }
        IXQEQueryNode[] aliasDefs = namedSetDef.getDescendantsOfType(1004, false);
        HashMap<IXQEQueryNode, IXQEQueryNode> mp = new HashMap<IXQEQueryNode, IXQEQueryNode>();
        int i = 0;
        for (i = 0; i < srcAliasDefs.length; ++i) {
            IXQEQueryNode matchedDef = null;
            for (int j = 0; j < aliasDefs.length; ++j) {
                if (!srcAliasDefs[i].isSameExpression(aliasDefs[j], false)) continue;
                matchedDef = aliasDefs[j];
                break;
            }
            if (matchedDef == null) {
                node.throwInternalError("no matching.");
            }
            mp.put(srcAliasDefs[i], matchedDef);
        }
        IXQEQueryNode[] aliasRefs = mdxQuery.getDescendantsOfType(1015, false);
        for (i = 0; i < aliasRefs.length; ++i) {
            MDXSetAliasReference ref = (MDXSetAliasReference)aliasRefs[i];
            MDXSetAliasDefinition def = ref.getDefinition();
            if (!mp.containsKey(def)) continue;
            ref.setDefinition((IXQEQueryNode)mp.get(def));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        if (requestEnv.isGetParametersRequest() && mdxQuery.isDMR()) {
            this.traceNodeCondition(false, "Do not execute when doing a GetParameter", trace);
            return false;
        }
        if (node.getParent().getType() == 1037 || node.getParent().getType() == 1033) {
            this.traceNodeCondition(false, "The parent of the target node is an MDXHierarcize or MDXDistinct node.  This transformation should be applied to the parent node.", trace);
            return false;
        }
        if (node.getParent().getType() == 1003) {
            this.traceNodeCondition(false, "The target node is a child of an MDXNamedSetDefinition node.", trace);
            return false;
        }
        if (node.getType() == 1039) {
            IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
            if (!capabilities.isSupported("mdx.optimize.set")) {
                this.traceNodeCondition(false, "The capability mdx.optimize.set is set to false.", trace);
                return false;
            }
            if (node.getNumberChildren() <= 1) {
                this.traceNodeCondition(false, "The target set has one member.", trace);
                return false;
            }
            MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
            if (edge != null && edge.isProjectedDescendant((MDXSet)node)) {
                this.traceNodeCondition(false, "The set is projected on an edge.", trace);
                return false;
            }
        }
        MDXHierInfo hierInfo = ((AbstractMDXNode)node).getContextHierarchyInfo();
        Iterator<IHierarchy> it = hierInfo.getProjectedHierarchies().iterator();
        while (it.hasNext()) {
            if (!((AbstractMDXSet)node).isContextDependent(it.next()) || ((AbstractMDXSet)node).isFlaggedContextIndependent()) continue;
            this.traceNodeCondition(false, "The target node is a context dependent set expression.", trace);
            return false;
        }
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        if (dimLine != null) {
            MDXHierInfo dimLineHierInfo = ((AbstractMDXNode)dimLine.getChild(0)).getHierarchyInfo();
            hierInfo.appendNewProjectedHierarchies(dimLineHierInfo);
            if (dimLine.getChild(0).getType() != 1069) {
                it = hierInfo.getProjectedHierarchies().iterator();
                while (it.hasNext()) {
                    if (!((AbstractMDXSet)node).isContextDependent(it.next())) continue;
                    this.traceNodeCondition(false, "The target node is context dependent on the slicer.", trace);
                    return false;
                }
            }
            List<Object> referencedCalcRefs = new ArrayList();
            referencedCalcRefs = dimLine.getDescendantsOfType(node.getType(), true, true, true, false, true);
            if (dimLine.getChild(0).getType() == 1069 && referencedCalcRefs.contains(node) && ((AbstractMDXNode)node).isContextDependent(true)) {
                return false;
            }
        }
        for (IXQEQueryNode parent = node.getParent(); parent != mdxQuery; parent = parent.getParent()) {
            if (!parent.isOfCategory(1001)) {
                this.traceNodeCondition(false, "The target node has an ancestor node between itself and the MDXQuery node that is not and AbstractMDXNode instance.", trace);
                return false;
            }
            if (!((AbstractMDXNode)parent).isTransformationNode()) continue;
            this.traceNodeCondition(false, "The target node has an ancestor node between itself and the MDXQuery node that is a transformation node.", trace);
            return false;
        }
        IXQEQueryNode[] aliasRefs = node.getDescendantsOfType(1015, false);
        if (aliasRefs.length > 0) {
            this.traceNodeCondition(false, "The target node expression contains alias references.", trace);
            return false;
        }
        if (node.getAncestorOfType(1008) != null) {
            this.traceNodeCondition(false, "The target node expression belongs to dimension line.", trace);
            return false;
        }
        IXQEQueryNode[] namedSetDefs = mdxQuery.getDescendantsOfType(1003, false);
        for (int i = 0; i < namedSetDefs.length; ++i) {
            if (!node.isSameExpression(namedSetDefs[i].getChild(0), false)) continue;
            this.traceNodeCondition(true, "The target node expression is the same as an existing named set.", trace);
            return true;
        }
        if (((AbstractMDXSet)node).projectsCalculatedMember()) {
            this.traceNodeCondition(false, "The target node projects a calculated member.", trace);
            return false;
        }
        if (PushExpressionEvaluationToDatabase.forceCreateNamedSet(node)) {
            this.traceNodeCondition(true, "The named set must be created for pushing evaluation to database.", trace);
            return true;
        }
        if (mdxQuery.getCapabilities().isSupported("mdx.support.namedSetCaching")) {
            this.traceNodeCondition(true, "The named set must be created to allow caching between queries.", trace);
            return true;
        }
        if (node.getParent().getType() == 1004 && node.getAncestorOfType(1003) != null) {
            this.traceNodeCondition(true, "Replace set alias with named set", trace);
            return true;
        }
        AbstractMDXNode mdxEdgeOrNamedSet = (AbstractMDXNode)node.getAncestorOfTypes(new int[]{1006, 1003});
        if (mdxEdgeOrNamedSet != null) {
            if (!mdxEdgeOrNamedSet.validateChildCategories()) {
                this.traceNodeCondition(false, "The child categories of the ancestor MDXEdge node are invalid.", trace);
                return false;
            }
            if (!node.isDescendantOfChildAtIndexForNodeOfType(1057, 1, true)) {
                MDXGenerate mdxGenerate;
                boolean forceCheckDuplicates = false;
                if (!mdxEdgeOrNamedSet.isProjectedDescendant((AbstractMDXNode)node) && mdxEdgeOrNamedSet.isProjectedDescendant(mdxGenerate = (MDXGenerate)node.getAncestorOfType(1057)) && ((AbstractMDXNode)mdxGenerate.getChild(0)).isProjectedDescendant((AbstractMDXNode)node)) {
                    forceCheckDuplicates = true;
                }
                if (forceCheckDuplicates || mdxEdgeOrNamedSet.isProjectedDescendant((AbstractMDXNode)node)) {
                    IXQEQueryNode[] querySetsOfSameType = mdxQuery.getDescendantsOfType(node.getType(), false);
                    boolean foundDuplicateSet = false;
                    for (int i = 0; i < querySetsOfSameType.length; ++i) {
                        if (querySetsOfSameType[i] == node || !node.isSameExpression(querySetsOfSameType[i], false)) continue;
                        foundDuplicateSet = true;
                    }
                    if (!foundDuplicateSet) {
                        this.traceNodeCondition(false, "The target node is projected by an MDXEdge node,  is not part of the second descendant tree of and MDXGenerate node, and does not have any duplicate nodes in the MDXQuery.", trace);
                        return false;
                    }
                }
            }
        }
        if (node.isValidPlannedQuery() != -1) {
            this.traceNodeCondition(false, "The target node expression is not a valid MDX expression.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The target node can be replaced with a named set.", trace);
        return true;
    }
}

