/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXSetItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class ReplaceVESetItemOnEmptySetWithNull
extends Transformation {
    public ReplaceVESetItemOnEmptySetWithNull(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace Value Expression MDXSetItem On Empty Set With Null";
        this.mTypes = new int[]{1054};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        node.getParent().exchangeChildNode(node, factory.createNode(1089), false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the target MDXSetItem node are invalid.", trace);
            return false;
        }
        if (!((MDXSetItem)node).isValueExpressionOperand()) {
            this.traceNodeCondition(false, "The target MDXSetItem node is not used in a value expression context.", trace);
            return false;
        }
        if (!((AbstractMDXSet)node.getChild(0)).isEmpty()) {
            this.traceNodeCondition(false, "The first operand of the MDXSetItem node will not evaluate to an empty set.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The target MDXSetItem node is used in a value expression context and the first operand will evaluate to an empty set.", trace);
        return true;
    }
}

