/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.crossjoin;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.optimization.MergeGenerateForCrossoin;
import com.cognos.xqe.transformation.olap.util.CollectTreeNodesForCondition;
import com.cognos.xqe.transformation.olap.util.MiscellaneousUtilities;
import com.cognos.xqeqte.QTESharedPassNumbers;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class CrossjoinToTuple
extends Transformation {
    public CrossjoinToTuple(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Convert MDXCrossjoin node into MDXTuple node.";
        this.mTypes = new int[]{1030};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXSet set1 = null;
        MDXTuple tuple1 = null;
        AbstractMDXSet set2 = null;
        MDXTuple tuple2 = null;
        AbstractMDXSet firstSet = (AbstractMDXSet)node.getChild(0);
        Set<IXQEQueryNode> firstSetMembers = this.crossjoinChildPassesCondition(firstSet);
        Iterator<IXQEQueryNode> itFirstSetMembers = firstSetMembers.iterator();
        AbstractMDXMember aFirstSetMember = (AbstractMDXMember)itFirstSetMembers.next();
        if (aFirstSetMember.getParent().getType() == 1069) {
            tuple1 = (MDXTuple)aFirstSetMember.getParent();
            set1 = (AbstractMDXSet)tuple1.getParent();
        } else {
            set1 = (AbstractMDXSet)aFirstSetMember.getParent();
        }
        AbstractMDXSet secondSet = (AbstractMDXSet)node.getChild(1);
        Set<IXQEQueryNode> secondSetMembers = this.crossjoinChildPassesCondition(secondSet);
        Iterator<IXQEQueryNode> itSecondSetMembers = secondSetMembers.iterator();
        AbstractMDXMember aSecondSetMember = (AbstractMDXMember)itSecondSetMembers.next();
        if (aSecondSetMember.getParent().getType() == 1069) {
            tuple2 = (MDXTuple)aSecondSetMember.getParent();
            set2 = (AbstractMDXSet)tuple2.getParent();
        } else {
            set2 = (AbstractMDXSet)aSecondSetMember.getParent();
        }
        AbstractMDXSet setToDiscard = null;
        AbstractMDXSet setToKeep = null;
        MDXTuple tupleToKeep = null;
        boolean insertBefore = true;
        if (set1.getType() == 1039 && set1.getParent() == node) {
            setToDiscard = (AbstractMDXSet)set1.detach();
            setToKeep = set2;
            insertBefore = true;
            if (tuple2 != null) {
                tupleToKeep = tuple2;
            }
        } else if (set2.getType() == 1039 && set2.getParent() == node) {
            setToDiscard = (AbstractMDXSet)set2.detach();
            insertBefore = false;
            setToKeep = set1;
            if (tuple1 != null) {
                tupleToKeep = tuple1;
            }
        }
        if (tupleToKeep == null) {
            tupleToKeep = (MDXTuple)nodeFactory.createNode(1069);
            setToKeep.getChild(0).insertParent(tupleToKeep);
        }
        IXQEQueryNode[] membersToMove = null;
        membersToMove = setToDiscard.getChild(0).getType() != 1069 ? setToDiscard.getChildren() : setToDiscard.getChild(0).getChildren();
        IXQEQueryNode firstTupleNode = tupleToKeep.getChild(0);
        for (int i = 0; i < membersToMove.length; ++i) {
            if (insertBefore) {
                tupleToKeep.addChildBeforeNode(membersToMove[i].detach(), firstTupleNode);
                continue;
            }
            tupleToKeep.addChild(membersToMove[i].detach());
        }
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXHierInfo hierInfo2;
        MDXHierInfo hierInfo1;
        AbstractMDXSet set1 = null;
        MDXTuple tuple1 = null;
        AbstractMDXSet set2 = null;
        MDXTuple tuple2 = null;
        XQETrace trace = environment.getTrace();
        boolean status = true;
        node.throwOnInvalidChildCategories();
        AbstractMDXSet firstSet = (AbstractMDXSet)node.getChild(0);
        AbstractMDXSet secondSet = (AbstractMDXSet)node.getChild(1);
        Set<IXQEQueryNode> firstSetMembers = this.crossjoinChildPassesCondition(firstSet);
        if (firstSetMembers == null) {
            this.traceNodeCondition(false, "The first crossjoin child does not pass the condition.", trace);
            return false;
        }
        Set<IXQEQueryNode> secondSetMembers = this.crossjoinChildPassesCondition(secondSet);
        if (secondSetMembers == null) {
            this.traceNodeCondition(false, "The second crossjoin child does not pass the condition.", trace);
            return false;
        }
        boolean bl = status = firstSetMembers.size() == 1 || secondSetMembers.size() == 1;
        if (!status) {
            this.traceNodeCondition(status, "None of the crossjoin children do project a single member.", trace);
            return status;
        }
        Iterator<IXQEQueryNode> itFirstSetMembers = firstSetMembers.iterator();
        AbstractMDXMember aFirstSetMember = (AbstractMDXMember)itFirstSetMembers.next();
        if (aFirstSetMember.getParent().getType() == 1069) {
            tuple1 = (MDXTuple)aFirstSetMember.getParent();
            set1 = (AbstractMDXSet)tuple1.getParent();
        } else {
            set1 = (AbstractMDXSet)aFirstSetMember.getParent();
        }
        Iterator<IXQEQueryNode> itSecondSetMembers = secondSetMembers.iterator();
        AbstractMDXMember aSecondSetMember = (AbstractMDXMember)itSecondSetMembers.next();
        if (aSecondSetMember.getParent().getType() == 1069) {
            tuple2 = (MDXTuple)aSecondSetMember.getParent();
            set2 = (AbstractMDXSet)tuple2.getParent();
        } else {
            set2 = (AbstractMDXSet)aSecondSetMember.getParent();
        }
        boolean bl2 = status = set1 != null && set1.getType() == 1039 && set1.getParent() == node || set2 != null && set2.getType() == 1039 && set2.getParent() == node;
        if (!status) {
            String traceMsg = "None of the crossjoin children is a MDXSet node projecting a single member or a single tuple.";
            this.traceNodeCondition(status, traceMsg, trace);
            return status;
        }
        if (tuple1 != null) {
            status = set1.getHierarchyInfo().compareProjectedHierarchies(tuple1.getHierarchyInfo());
            if (!status) {
                this.traceNodeCondition(status, "The first crossjoin child is a complex mutihiearchy set.", trace);
                return status;
            }
        } else {
            boolean bl3 = status = set1.getHierarchyInfo().getNumProjectedHierarchies() == 1;
            if (!status) {
                this.traceNodeCondition(status, "The first crossjoin child is a mutihiearchy set.", trace);
                return status;
            }
        }
        if (tuple2 != null) {
            status = set2.getHierarchyInfo().compareProjectedHierarchies(tuple2.getHierarchyInfo());
            if (!status) {
                this.traceNodeCondition(status, "The second crossjoin child is a complex mutihiearchy set.", trace);
                return status;
            }
        } else {
            boolean bl4 = status = set2.getHierarchyInfo().getNumProjectedHierarchies() == 1;
            if (!status) {
                this.traceNodeCondition(status, "The second crossjoin child is a mutihiearchy set.", trace);
                return status;
            }
        }
        if ((hierInfo1 = set1.getHierarchyInfo()).projectedHierarchiesOverlap(hierInfo2 = set2.getHierarchyInfo())) {
            String errMsg = "croosjoinSet1.getHierarchyInfo().projectedHierarchiesOverlap(croosjoinSet2.getHierarchyInfo())";
            node.throwInternalError(errMsg);
        }
        boolean bl5 = status = !MergeGenerateForCrossoin.checkNodeCondition(node, null);
        if (!status) {
            this.traceNodeCondition(status, "The MergeGenerateForCrossoin transformation is applicable and should have priority.", trace);
            return status;
        }
        return status;
    }

    private boolean doesCrossjoinChildPrjASingleMemberOrASingleTuple(Set<IXQEQueryNode> crossjoinChildPrjMembers) {
        if (crossjoinChildPrjMembers.isEmpty()) {
            return false;
        }
        boolean applyTransformation = true;
        MDXTuple tuple = null;
        for (IXQEQueryNode currMember : crossjoinChildPrjMembers) {
            IXQEQueryNode currParent = currMember.getParent();
            if (currParent.getType() == 1069) {
                if (tuple == null) {
                    tuple = (MDXTuple)currParent;
                    continue;
                }
                if (tuple == currParent) continue;
                applyTransformation = false;
                break;
            }
            if (crossjoinChildPrjMembers.size() <= 1) continue;
            applyTransformation = false;
            break;
        }
        return applyTransformation;
    }

    private Set<IXQEQueryNode> crossjoinChildPassesCondition(AbstractMDXSet crossjoinChild) {
        boolean status;
        HashSet<IXQEQueryNode> crossjoinChildMembers = new HashSet<IXQEQueryNode>();
        CollectTreeNodesForCondition.getProjectedDescendantMembers(crossjoinChildMembers, crossjoinChild);
        if (!this.doesCrossjoinChildPrjASingleMemberOrASingleTuple(crossjoinChildMembers)) {
            return null;
        }
        Iterator it = crossjoinChildMembers.iterator();
        AbstractMDXMember firstSetMember = (AbstractMDXMember)it.next();
        AbstractMDXSet ancestorSet = CrossjoinToTuple.getOuterContextIndepSetProjSingleMember(crossjoinChild, firstSetMember);
        boolean bl = status = ancestorSet != null && ancestorSet == crossjoinChild;
        if (!status) {
            return null;
        }
        return crossjoinChildMembers;
    }

    private static AbstractMDXSet getOuterContextIndepSetProjSingleMember(AbstractMDXSet boundarySet, AbstractMDXMember aMember) {
        AbstractMDXSet ancestorSet = (AbstractMDXSet)aMember.getAncestorOfCategory(1021);
        MDXHierInfo outerHierInfo = ((AbstractMDXSet)boundarySet.getParent()).getHierarchyInfo();
        MDXHierInfo boundarySetHierInfo = boundarySet.getHierarchyInfo();
        for (IHierarchy hierarchy : boundarySetHierInfo.getProjectedHierarchies()) {
            outerHierInfo.removeProjectedHierarchy(hierarchy);
        }
        while (true) {
            if (!ancestorSet.isCrossJoinToTupleApplicable()) {
                ancestorSet = null;
                break;
            }
            if (!MiscellaneousUtilities.isSingleProjMemberForSet(aMember, ancestorSet)) {
                ancestorSet = null;
                break;
            }
            IXQEQueryNode[] ancestorSetChildren = ancestorSet.getChildren();
            for (int i = 0; i < ancestorSetChildren.length; ++i) {
                AbstractMDXNode currChild = (AbstractMDXNode)ancestorSetChildren[i];
                if (!outerHierInfo.projectedHierarchiesOverlap(currChild.getHierarchyInfo())) continue;
                ancestorSet = null;
                break;
            }
            if (ancestorSet == null || ancestorSet == boundarySet || ancestorSet.getParent().getType() == 1030 || ancestorSet.getParent().getType() == 1027 && ancestorSet.getParent().getNumberChildren() > 1) break;
            IXQEQueryNode parent = ancestorSet.getParent();
            if (!parent.isOfCategory(1021)) {
                ancestorSet = null;
                break;
            }
            ancestorSet = (AbstractMDXSet)parent;
        }
        return ancestorSet;
    }
}

