/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.generate;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXDescendants;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeGenerateDescendantsOfCurrentMember
extends Transformation {
    public OptimizeGenerateDescendantsOfCurrentMember(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Optimize Generate Descendants Of CurrentMember.";
        this.mTypes = new int[]{1057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode newSet = null;
        if (node.getChild(0).getType() == 1052) {
            newSet = node.detachChild(1);
        } else {
            MDXDescendants descendants = (MDXDescendants)node.getChild(1);
            AbstractMDXMember member = (AbstractMDXMember)descendants.getChild(0);
            ILevel level = descendants.getLevelInfo().getProjectedLevel(member.getHierarchy(), 0);
            newSet = MDXBuilder.buildMDXMembersExpr((IXQENodeFactory)factory, level);
        }
        node.getParent().exchangeChildNode(node, newSet);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the MDXGenerate node are invalid.", trace);
            return false;
        }
        boolean validFirstSet = false;
        if (node.getChild(0).getType() == 1040 && node.getChild(0).getChild(0).getType() == 1065) {
            validFirstSet = true;
        } else if (node.getChild(0).getType() == 1052 && ((MDXDescendants)node.getChild(0)).getRangeFlag() == 0 && node.getChild(0).validateChildCategories() && node.getChild(0).getChild(0).getType() == 1076 && node.getChild(0).getChild(1).getType() == 1065) {
            validFirstSet = true;
        }
        if (!validFirstSet) {
            this.traceNodeCondition(false, "The first operand of the target MDXGenerate node is not an MDXMembers expression on a base level, or is not an MDXDescendants expression on an MDXCurrentMember  expression and a base level.", trace);
            return false;
        }
        if (node.getChild(1).getType() != 1052 || !node.getChild(1).validateChildCategories() || node.getChild(1).getChild(0).getType() != 1076) {
            this.traceNodeCondition(false, "The second operand of the target MDXGenerate node is not an MDXDescendants expression on an MDXCurrentMember expression.", trace);
            return false;
        }
        MDXDescendants descendants = (MDXDescendants)node.getChild(1);
        AbstractMDXMember member = (AbstractMDXMember)descendants.getChild(0);
        if (descendants.getLevelInfo().getNumProjectedLevels(member.getHierarchy()) != 1) {
            this.traceNodeCondition(false, "The MDXDescendants expression does not project a single level of members.", trace);
            return false;
        }
        MDXHierInfo firstSetHierInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo();
        MDXHierInfo secondSetHierInfo = ((AbstractMDXSet)node.getChild(1)).getHierarchyInfo();
        if (firstSetHierInfo.getNumProjectedHierarchies() != 1) {
            this.traceNodeCondition(false, "The first operand of the target MDXGenerate node does not project a single hierarchy.", trace);
            return false;
        }
        if (!firstSetHierInfo.compareProjectedHierarchies(secondSetHierInfo)) {
            this.traceNodeCondition(false, "The first and second operands of the target MDXGenerate node do not project the same hierarchy.", trace);
            return false;
        }
        IHierarchy hierarchy = firstSetHierInfo.getProjectedHierarchy(0);
        if (hierarchy.isRagged() || hierarchy.isUnbalanced()) {
            this.traceNodeCondition(false, "This transformation is not applicable to sets in ragged/unbalanced hierarchies.", trace);
            return false;
        }
        return true;
    }
}

