/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.generate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXGenerate;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;
import java.util.List;

public class OptimizeGenerateWithContextIndependentSet
extends Transformation {
    public OptimizeGenerateWithContextIndependentSet(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace GENERATE( {set}, {context independent set} ) with {context independent set}.";
        this.mTypes = new int[]{1057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode contextIndependentSet = node.getChild(1);
        node.getParent().exchangeChildNode(node, contextIndependentSet, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        node.throwOnInvalidChildCategories();
        if (node.getNumberChildren() == 2 && !((MDXGenerate)node).getAll() && !((AbstractMDXSet)node.getChild(1)).projectsDuplicates()) {
            IXQEQueryNode firstChild = node.getChild(0);
            IXQEQueryNode secondChild = node.getChild(1);
            if (firstChild.isOfCategory(1021)) {
                boolean bContextIndependent = true;
                MDXHierInfo mdxSetHierInfo = ((AbstractMDXSet)firstChild).getHierarchyInfo();
                List<IHierarchy> hierarchies = mdxSetHierInfo.getProjectedHierarchies();
                for (IHierarchy hierarchy : hierarchies) {
                    if (!((AbstractMDXNode)secondChild).isContextDependent(hierarchy)) continue;
                    bContextIndependent = false;
                    break;
                }
                status = bContextIndependent;
            }
        }
        if (!status) {
            this.traceNodeCondition(status, "The expression is not a valid one to optimize.", trace);
        }
        return status;
    }
}

