/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.summary;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueFunction;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXDescendants;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.MDXNumericOperator;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSetItem;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractReplaceSummaryWithMember
extends Transformation {
    private boolean simpleNode = false;

    AbstractMDXMember getRootMember(AbstractMDXSet abstractMDXSet, IXQENodeFactory nodeFactory) {
        AbstractMDXMember rootMember;
        IHierarchy hierarchy = abstractMDXSet.getHierarchyInfo().getProjectedHierarchy(0);
        String rootMUN = null;
        if (hierarchy.getRootMember() != null) {
            rootMUN = hierarchy.getRootMember().getUniqueName();
        }
        if (rootMUN == null) {
            ILevel rootlevel = hierarchy.getLevel(0);
            MDXMembers rootMembers = MDXBuilder.buildMDXMembersExpr(nodeFactory, rootlevel);
            MDXSetItem setItem = MDXBuilder.buildMDXSetItem(nodeFactory, (AbstractMDXSet)rootMembers, 0);
            rootMember = MDXBuilder.buildMDXTupleItem(nodeFactory, setItem, 0);
        } else {
            rootMember = MDXBuilder.buildMDXBaseMemberExpr(nodeFactory, rootMUN, hierarchy.getLevel(0));
        }
        return rootMember;
    }

    protected void transformSummaryForMultiRoot(MDXSummaryFunction summaryFn, IXQENodeFactory nodeFactory) {
        AbstractMDXSet abstractMDXSet = (AbstractMDXSet)summaryFn.getChild(0);
        IHierarchy hierarchy = abstractMDXSet.getHierarchyInfo().getProjectedHierarchy(0);
        MDXMembers rootMembers = MDXBuilder.buildMDXMembersExpr(nodeFactory, hierarchy.getLevel(0));
        summaryFn.exchangeChildNode(abstractMDXSet, rootMembers);
    }

    protected void replaceWithRootMember(MDXSummaryFunction summaryFn, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXSet abstractMDXSet = (AbstractMDXSet)summaryFn.getChild(0);
        IHierarchy hierarchy = abstractMDXSet.getHierarchyInfo().getProjectedHierarchy(0);
        if (hierarchy.isMultiRoot()) {
            this.transformSummaryForMultiRoot(summaryFn, nodeFactory);
        } else {
            ArrayList<AbstractMDXMember> members = new ArrayList<AbstractMDXMember>();
            abstractMDXSet = (AbstractMDXSet)summaryFn.detachChild(0);
            AbstractMDXMember rootMember = this.getRootMember(abstractMDXSet, nodeFactory);
            members.add(rootMember);
            this.replaceSummary(summaryFn, members, nodeFactory);
        }
    }

    protected void replaceWithMember(MDXSummaryFunction summaryFn, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXSet aggrSet = (AbstractMDXSet)summaryFn.detachChild(0);
        AbstractMDXMember member = (AbstractMDXMember)aggrSet.getChild(0);
        ArrayList<AbstractMDXMember> members = new ArrayList<AbstractMDXMember>();
        members.add(member);
        this.replaceSummary(summaryFn, members, nodeFactory);
    }

    protected void getMembersFromCrossjoinChild(IXQENodeFactory nodeFactory, MDXSummaryFunction orgSummaryFn, AbstractMDXSet set, ArrayList<AbstractMDXMember> members) {
        IHierarchy hierarchy = set.getHierarchyInfo().getProjectedHierarchy(0);
        MDXQuery mdxQuery = (MDXQuery)orgSummaryFn.getAncestorOfType(1002);
        AbstractMDXMember member = null;
        if (set.getType() == 1040 || set.getType() == 1057) {
            if (hierarchy.isMultiRoot()) {
                AbstractMDXValueExpression valueExpr = null;
                if (orgSummaryFn.getNumberChildren() == 1) {
                    valueExpr = (AbstractMDXValueExpression)nodeFactory.deepCopyNode((AbstractMDXValueExpression)orgSummaryFn.getChild(0));
                }
                MDXCalculatedMemberDefinition ancestorCalcMemberDef = (MDXCalculatedMemberDefinition)orgSummaryFn.getAncestorOfType(1005);
                int solveOrder = ancestorCalcMemberDef.getSolveOrder();
                MDXSummaryFunction newSummaryFn = MDXBuilder.buildMDXSummaryFunctionExpr(nodeFactory, orgSummaryFn.getSummaryType(), set, valueExpr);
                this.transformSummaryForMultiRoot(newSummaryFn, nodeFactory);
                MDXCalculatedMemberReference rootMember = MDXBuilder.buildMDXCalculatedMemberReference(nodeFactory, mdxQuery, hierarchy, "_RM", newSummaryFn, solveOrder);
                members.add(rootMember);
            } else {
                member = this.getRootMember(set, nodeFactory);
                members.add(member);
            }
        } else if (set.getType() == 1052 || set.getType() == 1048) {
            member = (AbstractMDXMember)set.getChild(0);
            members.add(member);
        } else if (set.getType() == 1030) {
            AbstractMDXSet set1 = (AbstractMDXSet)set.detachChild(0);
            this.getMembersFromCrossjoinChild(nodeFactory, orgSummaryFn, set1, members);
            AbstractMDXSet set2 = (AbstractMDXSet)set.detachChild(0);
            this.getMembersFromCrossjoinChild(nodeFactory, orgSummaryFn, set2, members);
        } else if (set.getType() == 1039) {
            Iterator<IXQEQueryNode> itChild = set.getChildrenIterator();
            while (itChild.hasNext()) {
                IXQEQueryNode aChild = itChild.next();
                if (aChild.isOfCategory(1022)) {
                    members.add((AbstractMDXMember)aChild);
                    continue;
                }
                if (!aChild.isOfCategory(1021)) continue;
                this.getMembersFromCrossjoinChild(nodeFactory, orgSummaryFn, (AbstractMDXSet)aChild, members);
            }
        }
    }

    protected void replaceSummaryOfCrossjoin(MDXSummaryFunction summaryFn, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)summaryFn.detachChild(0);
        ArrayList<AbstractMDXMember> members = new ArrayList<AbstractMDXMember>();
        AbstractMDXSet set1 = (AbstractMDXSet)mdxCrossjoin.detachChild(0);
        this.getMembersFromCrossjoinChild(nodeFactory, summaryFn, set1, members);
        AbstractMDXSet set2 = (AbstractMDXSet)mdxCrossjoin.detachChild(0);
        this.getMembersFromCrossjoinChild(nodeFactory, summaryFn, set2, members);
        this.replaceSummary(summaryFn, members, nodeFactory);
    }

    protected void replaceSummary(MDXSummaryFunction summaryFn, ArrayList<AbstractMDXMember> members, IXQENodeFactory nodeFactory) {
        IXQEQueryNode member;
        int i;
        IXQEQueryNode value = null;
        IXQEQueryNode tuple = null;
        if (summaryFn.getNumberChildren() == 1) {
            tuple = summaryFn.getChild(0).getChild(0);
            for (i = 0; i < members.size(); ++i) {
                member = nodeFactory.deepCopyNode(members.get(i));
                tuple.addChild((AbstractMDXMember)member);
            }
            value = summaryFn.detachChild(0);
        } else {
            tuple = nodeFactory.createNode(1069);
            for (i = 0; i < members.size(); ++i) {
                member = nodeFactory.deepCopyNode(members.get(i));
                tuple.addChild((AbstractMDXMember)member);
            }
            value = nodeFactory.createNode(1059);
            value.addChild(tuple);
        }
        IXQEQueryNode parentNode = summaryFn.getParent();
        parentNode.exchangeChildNode(summaryFn, value);
        MDXQuery mdxQuery = (MDXQuery)parentNode.getAncestorOfType(1002);
        if (mdxQuery != null && mdxQuery.isListReport() && this.simpleNode) {
            mdxQuery.setSummaryMeasureInQuery(true);
        }
    }

    protected boolean queryCondition(MDXSummaryFunction summaryFn, PlanningEnvironment environment, boolean rolapPeriodsToDate) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        StringBuilder msgStr = new StringBuilder();
        if (!summaryFn.validateChildCategories()) {
            this.traceQueryCondition(false, "The MDXSummaryFunction node is not well constructed.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)summaryFn.getAncestorOfType(1002);
        MDXCalculatedMemberDefinition calcDef = (MDXCalculatedMemberDefinition)summaryFn.getAncestorOfType(1005);
        if (mdxQuery == null) {
            status = false;
            msgStr.append("The node is not within a MDXQuery node.");
        } else if (calcDef == null) {
            status = false;
            msgStr.append("The node is not a descendant of an MDXCalculatedMemberDefinition node.");
        } else if (mdxQuery.isRelationalStyleQuery() || mdxQuery.isRelationaCrosstab()) {
            status = false;
            msgStr.append("The node is in a relational style or relational crosstab query.");
        } else {
            int i;
            status = true;
            msgStr.append("The node is within a MDXQuery node.");
            IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
            if (!capabilities.isSupported("mdx.optimize.parentmember")) {
                msgStr.append(" The datasource type does not support parent member replacement.");
                return false;
            }
            msgStr.append(" The MDXSummaryFunction node aggregate is: '");
            msgStr.append(summaryFn.getMDXSummaryString());
            msgStr.append("'.");
            boolean includeSelf = false;
            List<IXQEQueryNode> members = mdxQuery.getDescendantsOfCategory(1022, includeSelf);
            ArrayList<IMember> measures = new ArrayList<IMember>();
            for (i = 0; i < members.size(); ++i) {
                AbstractMDXMember member = (AbstractMDXMember)members.get(i);
                IHierarchy memberHierarchy = member.getHierarchy();
                if (memberHierarchy == null || memberHierarchy.getDimension() == null || !memberHierarchy.getDimension().isMeasuresDimension() || member.isOfCategory(1077)) continue;
                if (member.isOfCategory(1067)) {
                    measures.add(((BaseMember)member).getMember());
                    continue;
                }
                if (member.isOfCategory(1013) || member.isOfCategory(1076)) continue;
                msgStr.append(" There exists a measure that is not known.");
                status = false;
                break;
            }
            if (mdxQuery.isYukonProvider()) {
                if (mdxQuery.getIncludeCalculatedMembers()) {
                    msgStr.append(" Yukon query might contain database calculated members. ");
                    status = false;
                }
                if (measures.size() != members.size()) {
                    for (i = 0; i < members.size(); ++i) {
                        AbstractMDXMember explicitMember = (AbstractMDXMember)members.get(i);
                        if (!explicitMember.isOfCategory(1067) || ((BaseMember)explicitMember).isMeasure() || ((BaseMember)explicitMember).isRootMember()) continue;
                        msgStr.append(" Yukon query might contain database calculated members.");
                        status = false;
                    }
                }
            }
            if (summaryFn.getSummaryType() != MDXSummaryFunctionTypeEnum.SUM && summaryFn.getSummaryType() != MDXSummaryFunctionTypeEnum.MINIMUM && summaryFn.getSummaryType() != MDXSummaryFunctionTypeEnum.MAXIMUM && summaryFn.getSummaryType() != MDXSummaryFunctionTypeEnum.AGGREGATE) {
                status = false;
            } else {
                ROLAPCube rolapCube;
                String cubeUniqueName;
                IAggregateRule[] rules;
                Object regularAggregate;
                IMember baseMember;
                boolean relational = mdxQuery.getMDXFrom().getCube().getModelDataSource().isRelational();
                boolean rolap = mdxQuery.getDataSourceType().equals("RO");
                if (summaryFn.getSummaryType() == MDXSummaryFunctionTypeEnum.AGGREGATE) {
                    if (!(mdxQuery.getDataSourceType().equals("BW") || rolap || mdxQuery.getDataSourceType().equals("XO") || relational)) {
                        status = false;
                    } else if (rolap && rolapPeriodsToDate) {
                        for (int i2 = 0; i2 < measures.size(); ++i2) {
                            baseMember = (IMember)measures.get(i2);
                            regularAggregate = baseMember.getRegularAggregate();
                            if (regularAggregate != AggregateTypeEnum.SUM && regularAggregate != AggregateTypeEnum.MIN && regularAggregate != AggregateTypeEnum.MAX) {
                                status = false;
                                msgStr.append(" External aggregate of measure: '");
                                msgStr.append(baseMember.getUniqueName());
                                msgStr.append("' is of unsupported type");
                                break;
                            }
                            rules = baseMember.getAggregateRules();
                            if (rules.length > 0) {
                                cubeUniqueName = baseMember.getHierarchy().getDimension().getCube().getUniqueName();
                                rolapCube = ROLAPCubeManager.getInstance().getCube(cubeUniqueName);
                                if (rolapCube == null) {
                                    rolap = false;
                                }
                                if (rolap && rolapCube.isVirtual()) {
                                    status = false;
                                    msgStr.append(" The aggregate rule of external virtual measure: '");
                                    msgStr.append(baseMember.getUniqueName());
                                    msgStr.append("' is always empty.");
                                    msgStr.append(" Treat it as different from the summary function");
                                    break;
                                }
                            }
                            if (rules.length <= 0) continue;
                            status = false;
                            msgStr.append(" External measure: '");
                            msgStr.append(baseMember.getUniqueName());
                            msgStr.append("' contains semi-aggregate rule");
                            break;
                        }
                    }
                }
                if (summaryFn.getSummaryType() == MDXSummaryFunctionTypeEnum.SUM || summaryFn.getSummaryType() == MDXSummaryFunctionTypeEnum.MINIMUM || summaryFn.getSummaryType() == MDXSummaryFunctionTypeEnum.MAXIMUM) {
                    block3: for (int i3 = 0; i3 < measures.size(); ++i3) {
                        baseMember = (IMember)measures.get(i3);
                        regularAggregate = baseMember.getRegularAggregate().getModelName();
                        if (!((String)regularAggregate).equalsIgnoreCase(summaryFn.getMDXSummaryString())) {
                            status = false;
                            msgStr.append(" The regular aggregate of measure: '");
                            msgStr.append(baseMember.getUniqueName());
                            msgStr.append("' is :'");
                            msgStr.append((String)regularAggregate);
                            msgStr.append("'. Which different from the summary function.");
                            break;
                        }
                        if (!relational && !rolap) continue;
                        rules = baseMember.getAggregateRules();
                        if (rules.length == 0 && rolap) {
                            cubeUniqueName = baseMember.getHierarchy().getDimension().getCube().getUniqueName();
                            rolapCube = ROLAPCubeManager.getInstance().getCube(cubeUniqueName);
                            if (rolapCube.isVirtual()) {
                                status = false;
                                msgStr.append(" The aggregate rule of virtual measure: '");
                                msgStr.append(baseMember.getUniqueName());
                                msgStr.append("' is always empty");
                                msgStr.append(". Treat it as different from the summary function");
                                break;
                            }
                        }
                        for (IAggregateRule rule : rules) {
                            AggregateTypeEnum aggrType = rule.getAggregate();
                            if (!(summaryFn.getSummaryType() == MDXSummaryFunctionTypeEnum.SUM && aggrType != AggregateTypeEnum.SUM || summaryFn.getSummaryType() == MDXSummaryFunctionTypeEnum.MINIMUM && aggrType != AggregateTypeEnum.MIN) && (summaryFn.getSummaryType() != MDXSummaryFunctionTypeEnum.MAXIMUM || aggrType == AggregateTypeEnum.MAX)) continue;
                            status = false;
                            msgStr.append(" The aggregate rule of measure: '");
                            msgStr.append(baseMember.getUniqueName());
                            msgStr.append("' is ");
                            msgStr.append("'different from the summary function.");
                            continue block3;
                        }
                    }
                }
                if (status && !relational && !rolap) {
                    for (int i4 = 0; i4 < measures.size(); ++i4) {
                        String regularAggregate2;
                        baseMember = (IMember)measures.get(i4);
                        String semiAggregate = baseMember.getSemiAggregate().getModelName();
                        if (semiAggregate.equalsIgnoreCase(regularAggregate2 = baseMember.getRegularAggregate().getModelName()) || semiAggregate.equalsIgnoreCase("UNSUPPORTED")) continue;
                        status = false;
                        msgStr.append(" The regular aggregate and the semi aggregate of measure: '");
                        msgStr.append(baseMember.getUniqueName());
                        msgStr.append("' do not match (");
                        msgStr.append(regularAggregate2);
                        msgStr.append(", ");
                        msgStr.append(semiAggregate);
                        msgStr.append(").");
                        break;
                    }
                }
            }
        }
        this.traceQueryCondition(status, msgStr.toString(), trace);
        return status;
    }

    protected int isValidSetForNumericValueOfCubeTuple(AbstractMDXSet set) {
        set.throwOnInvalidChildCategories();
        switch (set.getType()) {
            case 1052: {
                MDXDescendants desc = (MDXDescendants)set;
                AbstractMDXMember member = (AbstractMDXMember)set.getChild(0);
                if (desc.getLevelInfo().getNumProjectedLevels(member.getHierarchy()) != 1) break;
            }
            case 1048: {
                return set.getType();
            }
            case 1040: {
                if (!set.getChild(0).isOfCategory(1023)) break;
                return set.getType();
            }
            case 1030: {
                if (this.isValidSetForNumericValueOfCubeTuple((AbstractMDXSet)set.getChild(0)) != 0 && this.isValidSetForNumericValueOfCubeTuple((AbstractMDXSet)set.getChild(1)) != 0) {
                    return 1030;
                }
            }
            case 1039: {
                int result = 0;
                if (set.getNumberChildren() == 1) {
                    IXQEQueryNode aChild = set.getChild(0);
                    if (aChild.isOfCategory(1022)) {
                        result = set.getType();
                    } else if (aChild.isOfCategory(1021)) {
                        result = this.isValidSetForNumericValueOfCubeTuple((AbstractMDXSet)aChild);
                    }
                }
                return result;
            }
        }
        return 0;
    }

    protected boolean canIntersectWithLowerSOComplexCalc(MDXQuery mdxQuery, MDXCalculatedMemberDefinition givenDef, MDXSummaryFunction summaryFn) {
        int solveOrder = givenDef.getSolveOrder();
        boolean isListReportSummary = false;
        if (mdxQuery.isListReport()) {
            MDXCalculatedMemberReference cmRef;
            Iterator<MDXCalculatedMemberReference> iterator = givenDef.getCalcMemberRefs().iterator();
            while (iterator.hasNext() && (isListReportSummary = (cmRef = iterator.next()).isReportSummary())) {
            }
        }
        IXQEQueryNode[] cmRefs = mdxQuery.getDescendantsOfType(1013, false);
        for (int i = 0; i < cmRefs.length; ++i) {
            MDXCalculatedMemberReference cmRef = (MDXCalculatedMemberReference)cmRefs[i];
            MDXCalculatedMemberDefinition cmDef = cmRef.getDefinition();
            if (mdxQuery.isListReport() && isListReportSummary && cmRef.isReportSummary() || cmDef == givenDef || cmDef.getSolveOrder() > solveOrder || cmDef.getHierarchy() == givenDef.getHierarchy() || !summaryFn.isContextDependent(cmDef.getHierarchy())) continue;
            if (cmDef.getHierarchy().getDimension().isMeasuresDimension() && !summaryFn.getIntersectingMeasures().isEmpty()) {
                boolean foundIt = false;
                Iterator<AbstractMDXMember> it = summaryFn.getIntersectingMeasures().iterator();
                while (it.hasNext()) {
                    if (!it.next().isSameExpression(cmRef, false)) continue;
                    foundIt = true;
                    break;
                }
                if (!foundIt) continue;
            }
            IXQEQueryNode[] constants = cmDef.getDescendantsOfType(1064, false);
            for (int k = 0; k < constants.length; ++k) {
                AbstractMDXNode constant = (AbstractMDXNode)constants[k];
                int[] validAncestorsForConstant = new int[]{1021, 1071, 1055};
                if (constant.getAncestorOfCategories(validAncestorsForConstant) != null) continue;
                return true;
            }
            IXQEQueryNode[] sumFns = cmDef.getDescendantsOfType(1060, false);
            AbstractMDXNode givenDefExpr = (AbstractMDXNode)givenDef.getChild(0);
            Set<IHierarchy> refHierarchies = givenDefExpr.getReferencedHierarchies();
            for (int j = 0; j < sumFns.length; ++j) {
                IXQEQueryNode sumFn = sumFns[j];
                sumFn.throwOnInvalidChildCategories();
                AbstractMDXSet sumSet = (AbstractMDXSet)sumFn.getChild(0);
                MDXHierInfo hierInfo = sumSet.getHierarchyInfo();
                for (IHierarchy hierarchy : refHierarchies) {
                    if (!sumSet.isContextDependent(hierarchy) && !hierInfo.projectsHierarchy(hierarchy)) continue;
                    return true;
                }
            }
            IXQEQueryNode[] numericOps = cmDef.getDescendantsOfType(1084, false);
            for (int j = 0; j < numericOps.length; ++j) {
                MDXNumericOperator sumFn = (MDXNumericOperator)numericOps[j];
                if (sumFn.getOperatorProperty() != 2 && sumFn.getOperatorProperty() != 3) continue;
                return true;
            }
            List<IXQEQueryNode> summaryFns = cmDef.getDescendantsOfCategory(1088, false);
            for (int j = 0; j < summaryFns.size(); ++j) {
                AbstractMDXNumericValueFunction cmDefFn = (AbstractMDXNumericValueFunction)summaryFns.get(j);
                if (cmDefFn.getType() != summaryFn.getType()) {
                    return true;
                }
                if (cmDefFn.getType() != 1060 || ((MDXSummaryFunction)cmDefFn).getSummaryType() == summaryFn.getSummaryType()) continue;
                return true;
            }
            IXQEQueryNode[] scalarFns = cmDef.getDescendantsOfType(1144, false);
            if (scalarFns.length <= 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isNumericValueOfCubeTuple(MDXSummaryFunction summaryFn, StringBuilder msgStr, boolean rolapPeriodsToDate) {
        String s1 = " The summary second child node is";
        String s2 = " a MDXValue(MDXTuple(MDXAbstractMember1[,...,MDXAbstractMembern]).";
        String s5 = " The solve order of the associated MDXCalculatedMemberDefinition node is";
        String s6 = " the lowest one in the given MDXQuery.";
        String s7 = " The summary first child node is";
        String s8 = " any of these: MDXDescendants(BaseMember), MDXChildren(BaseMember), MDXMembers(),";
        String s9 = " MDXGenerate(MDXMembers, MDXDescendants(MDXCurrentMember)), MDXGenerate(MDXMembers,";
        String s10 = " MDXDescendants(MDXCurrentMember)), MDXCrossjoin(validSet1, validSet2)";
        String s11 = " All dimensions roolUp to hier levels.";
        String s12 = " At least dimension '";
        String s13 = "' does not roolUp to hier levels.";
        summaryFn.throwOnInvalidChildCategories();
        boolean isCubeValue = false;
        if (summaryFn.getNumberChildren() == 1 || summaryFn.getNumberChildren() == 2 && ((AbstractMDXValueExpression)summaryFn.getChild(1)).isNumericValueOfCubeTuple()) {
            MDXHierInfo veHierInfo = null;
            if (summaryFn.getNumberChildren() == 2) {
                veHierInfo = ((AbstractMDXNode)summaryFn.getChild(1).getChild(0)).getHierarchyInfo();
                msgStr.append(" The summary second child node is");
                msgStr.append(" a MDXValue(MDXTuple(MDXAbstractMember1[,...,MDXAbstractMembern]).");
            }
            MDXCalculatedMemberDefinition ancestorCalcMemberDef = (MDXCalculatedMemberDefinition)summaryFn.getAncestorOfType(1005);
            MDXQuery mdxQuery = (MDXQuery)summaryFn.getAncestorOfType(1002);
            boolean bl = isCubeValue = !this.canIntersectWithLowerSOComplexCalc(mdxQuery, ancestorCalcMemberDef, summaryFn);
            if (!isCubeValue) {
                msgStr.append("Found a complex calculation of a lowest solver than that of the given summary.");
            }
            if (isCubeValue) {
                IHierarchy hierarchy;
                IDimension dimension;
                this.simpleNode = true;
                msgStr.append(" The solve order of the associated MDXCalculatedMemberDefinition node is");
                msgStr.append(" the lowest one in the given MDXQuery.");
                AbstractMDXSet summarySet = (AbstractMDXSet)summaryFn.getChild(0);
                MDXHierInfo sumSetHierInfo = summarySet.getHierarchyInfo();
                for (int i = 0; i < sumSetHierInfo.getNumProjectedHierarchies() && (isCubeValue = (dimension = (hierarchy = sumSetHierInfo.getProjectedHierarchy(i)).getDimension()).getMembersRollup()); ++i) {
                    if (veHierInfo == null || !veHierInfo.projectsHierarchy(hierarchy)) continue;
                    msgStr.append("The summary set projects same hierarchy as one in the value expression.");
                    return false;
                }
                if (isCubeValue) {
                    msgStr.append(" All dimensions roolUp to hier levels.");
                    int isValidChild = this.isValidSetForNumericValueOfCubeTuple(summarySet);
                    if (rolapPeriodsToDate || isValidChild != 0) {
                        msgStr.append(" The summary first child node is");
                        msgStr.append(" any of these: MDXDescendants(BaseMember), MDXChildren(BaseMember), MDXMembers(),");
                        msgStr.append(" MDXGenerate(MDXMembers, MDXDescendants(MDXCurrentMember)), MDXGenerate(MDXMembers,");
                        msgStr.append(" MDXDescendants(MDXCurrentMember)), MDXCrossjoin(validSet1, validSet2)");
                        isCubeValue = true;
                    } else {
                        msgStr.append(" The summary first child node is");
                        msgStr.append(" ");
                        msgStr.append("not");
                        msgStr.append(" any of these: MDXDescendants(BaseMember), MDXChildren(BaseMember), MDXMembers(),");
                        msgStr.append(" MDXGenerate(MDXMembers, MDXDescendants(MDXCurrentMember)), MDXGenerate(MDXMembers,");
                        msgStr.append(" MDXDescendants(MDXCurrentMember)), MDXCrossjoin(validSet1, validSet2)");
                        isCubeValue = false;
                    }
                } else {
                    msgStr.append(" At least dimension '");
                    msgStr.append("' does not roolUp to hier levels.");
                }
            } else {
                msgStr.append(" The solve order of the associated MDXCalculatedMemberDefinition node is");
                msgStr.append(" ");
                msgStr.append("not");
                msgStr.append(" the lowest one in the given MDXQuery.");
            }
        } else if (summaryFn.getNumberChildren() == 2) {
            msgStr.append(" The summary second child node is");
            msgStr.append(" ");
            msgStr.append("not");
            msgStr.append(" a MDXValue(MDXTuple(MDXAbstractMember1[,...,MDXAbstractMembern]).");
        } else {
            summaryFn.throwInternalError("");
        }
        return isCubeValue;
    }

    public boolean nodeCondition(MDXSummaryFunction summaryFn, StringBuilder msgStr, boolean rolapPeriodsToDate) {
        boolean status = true;
        String s1 = " The summary set is only projecting the root level of a multi root hierarchy.";
        AbstractMDXSet abstractMDXSet = (AbstractMDXSet)summaryFn.getChild(0);
        MDXHierInfo hierInfo = abstractMDXSet.getHierarchyInfo();
        IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
        if (hierInfo.getNumProjectedHierarchies() == 1 && hierarchy.isMultiRoot()) {
            MDXLevelInfo levelInfo = abstractMDXSet.getLevelInfo();
            ILevel level = levelInfo.getHighestProjectedLevel(hierarchy);
            status = levelInfo.getNumProjectedLevels(hierarchy) == 1 && !level.isRootLevel();
        }
        for (IHierarchy hier : hierInfo.getProjectedHierarchies()) {
            if (!hier.isRagged() && !hier.isUnbalanced()) continue;
            msgStr.append("The summary set projects a ragged or unbalanced hierarchy.");
            return false;
        }
        if (status) {
            status = this.isNumericValueOfCubeTuple(summaryFn, msgStr, rolapPeriodsToDate);
        } else {
            msgStr.append(" The summary set is only projecting the root level of a multi root hierarchy.");
        }
        return status;
    }
}

