/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXParameterMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.ConvertDimensionLineTupleToSet;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class RemoveSummaryOnSingleTupleExpression
extends Transformation {
    public RemoveSummaryOnSingleTupleExpression() {
        this.mName = "Replace summary function on single member by this member.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1060};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getNumberChildren() == 1) {
            IXQEQueryNode set = node.getChild(0);
            IXQEQueryNode setChild = set.detachChild(0);
            XQENodeFactory factory = environment.getNodeFactory();
            if (setChild.getType() != 1069) {
                IXQEQueryNode tuple = factory.createNode(1069);
                tuple.addChild(setChild);
                setChild = tuple;
            }
            AbstractMDXNumericValueExpression valueExpression = MDXBuilder.coerceToNumericValueExpression(setChild, factory);
            node.getParent().exchangeChildNode(node, valueExpression);
        } else {
            IXQEQueryNode set = node.getChild(0);
            IXQEQueryNode tuple = node.getChild(1).getChild(0);
            if (set.getChild(0).getType() == 1069) {
                set = set.getChild(0);
            }
            boolean addChild = true;
            int i = 0;
            while (i < set.getNumberChildren() && addChild) {
                AbstractMDXMember member = (AbstractMDXMember)set.getChild(i);
                for (int j = 0; j < tuple.getNumberChildren(); ++j) {
                    if (member.getHierarchy() != ((AbstractMDXMember)tuple.getChild(j)).getHierarchy()) continue;
                    addChild = false;
                }
                if (addChild) {
                    member.move(tuple, 0);
                    continue;
                }
                ++i;
            }
            node.detachFirstChild();
            node.extract();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXDimensionLine dimLine;
        boolean result;
        MDXQuery mdxQuery;
        IXQEQueryNode calDef;
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the target MDXSummaryFunction node are invalid.", trace);
            return false;
        }
        MDXSummaryFunction summaryFunction = (MDXSummaryFunction)node;
        MDXSummaryFunctionTypeEnum summaryType = summaryFunction.getSummaryType();
        if (summaryType != MDXSummaryFunctionTypeEnum.AGGREGATE && summaryType != MDXSummaryFunctionTypeEnum.AVERAGE && summaryType != MDXSummaryFunctionTypeEnum.MAXIMUM && summaryType != MDXSummaryFunctionTypeEnum.MINIMUM && summaryType != MDXSummaryFunctionTypeEnum.SUM) {
            this.traceNodeCondition(false, "The summary function is not for a valid aggregation type.", trace);
            return false;
        }
        IXQEQueryNode set = node.getChild(0);
        if (set.getType() != 1039) {
            this.traceNodeCondition(false, "The summary function first argument is not a MDX Set.", trace);
            return false;
        }
        if (set.getNumberChildren() != 1) {
            this.traceNodeCondition(false, "The summary function has more than a single argument.", trace);
            return false;
        }
        IXQEQueryNode member = set.getChild(0);
        if (!member.isOfCategory(1022) && member.getType() != 1069) {
            this.traceNodeCondition(false, "The summary function is not aggregating a single member or a tuple.", trace);
            return false;
        }
        if (member.getType() == 1069) {
            for (int i = 0; i < member.getNumberChildren(); ++i) {
                if (member.getChild(i).isOfCategory(1022)) continue;
                this.traceNodeCondition(false, "The summary function is aggregating complex set expression.", trace);
                return false;
            }
        }
        if (member.getType() == 1129 && ((MDXParameterMember)member).isMasterDetailParameter() && ((MDXParameterMember)member).couldBeEmpty() && (calDef = node.getAncestorOfType(1005)) != null) {
            for (MDXCalculatedMemberReference ref : ((MDXCalculatedMemberDefinition)calDef).getCalcMemberRefs()) {
                if (ref.getAncestorOfType(1008) == null) continue;
                this.traceNodeCondition(false, "The summary function is aggregating a single parameter. The summary function belongs to a calculated member that referenced by dimension line.", trace);
                return false;
            }
        }
        if (node.getNumberChildren() == 2) {
            IXQEQueryNode valueNode = node.getChild(1);
            if (valueNode.getType() != 1059) {
                this.traceNodeCondition(false, "The summary function second argument is not a numerical expression.", trace);
                return false;
            }
            if (valueNode.getNumberChildren() != 1) {
                this.traceNodeCondition(false, "The numerical expression in the summary function is either a constant or a complex expression.", trace);
                return false;
            }
            if (valueNode.getChild(0).getType() != 1069) {
                this.traceNodeCondition(false, "The numerical expression in the summary function is not a single tuple.", trace);
                return false;
            }
        }
        if (node.getParent().getType() == 1005 && ((MDXCalculatedMemberDefinition)node.getParent()).getPrefix().equals("_MDF") && RemoveSummaryOnSingleTupleExpression.ckeckDataSourceType(YukonTransformation.YK_DATASOURCE_TYPES, mdxQuery = (MDXQuery)node.getAncestorOfType(1002)) && (result = ConvertDimensionLineTupleToSet.nodeCondition(dimLine = mdxQuery.getDimensionLine(), null))) {
            this.traceNodeCondition(false, "Apply first ConvertDimensionLineTupleToSet.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The summary function is aggregating a single member or a tuple.", trace);
        return true;
    }

    private static boolean ckeckDataSourceType(String[] dataSourceTypeArray, MDXQuery mdxQuery) {
        String queryDataSource = mdxQuery.getDataSourceType();
        for (int i = 0; i < dataSourceTypeArray.length; ++i) {
            if (!queryDataSource.equals(dataSourceTypeArray[i])) continue;
            return true;
        }
        return false;
    }
}

