/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.projection;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public class AddMasterQueryProjectedExprsToMDLink
extends Transformation {
    public AddMasterQueryProjectedExprsToMDLink() {
        this.mName = "Add expressions used as m-d link in master query to MasterDetailLink.";
        this.mPassNumbers = new int[]{33};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RequestEnvironment reqEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
        MasterDetailProvider mdProvider = reqEnvironment.getMasterDetailProvider();
        String qrdName = ((RSAPIDataset)mdxQuery.getAncestorOfType(401005)).getName();
        List<MasterDetailLink> links = mdProvider.getMasterDetailLinks(qrdName);
        List<AbstractMDXNode> sets = mdxQuery.getDescendantsOfCategory(1021, false, true, false, false, false);
        block0: for (MasterDetailLink mdLink : links) {
            String refItemName = mdLink.getMasterRefDataItem();
            for (AbstractMDXNode set : sets) {
                AbstractMDXSet abstractSet = (AbstractMDXSet)set;
                if (abstractSet.getRefDataItemProperty() == null || !abstractSet.getRefDataItemProperty().equals(refItemName)) continue;
                AbstractMDXSet masterLinkSet = (AbstractMDXSet)abstractSet.getChild(0);
                masterLinkSet.setRefDataItemProperty(refItemName);
                mdLink.setMasterLinkSetExpr((AbstractMDXSet)nodeFactory.deepCopyNode(masterLinkSet));
                continue block0;
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (!capabilities.isSupported("v5.planSubQueryForLocalOLAP")) {
            this.traceNodeCondition(false, "The configuration of planning sub query for LOLAP is set to false.", trace);
            return false;
        }
        if (!mdxQuery.getUseLocalQueryProcessing() || !mdxQuery.isRemoteDatasourceOLAP()) {
            this.traceNodeCondition(false, "The MDXQuery is NOT against LOLAP. No sub query is required.", trace);
            return false;
        }
        if (!mdxQuery.requiresLocalSubMDXQuery()) {
            this.traceNodeCondition(false, "No priming query is required.", trace);
            return false;
        }
        RequestEnvironment reqEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
        String requestName = reqEnvironment.getOperationName();
        if (null != requestName && !requestName.equals("execute") && !requestName.equals("executeDetailQuery")) {
            this.traceNodeCondition(false, "The query is not received as an Execution request.", trace);
            return false;
        }
        MasterDetailProvider mdProvider = reqEnvironment.getMasterDetailProvider();
        if (mdProvider == null) {
            this.traceNodeCondition(false, "This query is not one of the master-detail queries.", trace);
            return false;
        }
        String qrdName = ((RSAPIDataset)mdxQuery.getAncestorOfType(401005)).getName();
        List<MasterDetailLink> links = mdProvider.getMasterDetailLinks(qrdName);
        if (links == null || links.isEmpty()) {
            this.traceNodeCondition(false, "This query is not a master query.", trace);
            return false;
        }
        if (links.get(0).getMasterLinkSetExpr() != null) {
            this.traceNodeCondition(false, "This master set expression is already set to the m-d link.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This is a mater query neet.", trace);
        return true;
    }
}

