/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.projection;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class SetEmptySetOnCogMdxGroupContextDependent
extends Transformation {
    private static final String PROP_APPLY = "SetEmptySetOnCogMdxGroupContextDependent";
    private static final String PROP_APPLY_VALUE = "applied";

    public SetEmptySetOnCogMdxGroupContextDependent() {
        this.mName = "Set Emptyset for Nested CogMDXGroup.";
        this.mPassNumbers = new int[]{33, 39};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup thisGrp = (CogMDXGroup)node;
        XQENodeFactory factory = environment.getNodeFactory();
        AbstractMDXSet groupSet = (AbstractMDXSet)thisGrp.getChild(0);
        AbstractMDXSet emptySet = MDXBuilder.buildEmptySet(factory, groupSet);
        thisGrp.exchangeChildNode(groupSet, emptySet, false);
        thisGrp.setPropertyValue(PROP_APPLY, PROP_APPLY_VALUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROP_APPLY) != null) {
            this.traceNodeCondition(false, "The correlation already done or not required.", trace);
            return false;
        }
        CogMDXGroup thisGrp = (CogMDXGroup)node;
        AbstractMDXSet groupSet = (AbstractMDXSet)node.getChild(0);
        if (groupSet.getType() == 1145) {
            this.traceQueryCondition(false, "The node is already defined as EmptySet.", trace);
            return false;
        }
        boolean bPassCondition = false;
        IXQEQueryNode[] ancestorNodes = node.getAncestorsOfType(1027);
        int i = 0;
        for (i = 0; i < ancestorNodes.length; ++i) {
            CogMDXGroup grp = (CogMDXGroup)ancestorNodes[i];
            if (!grp.isProjectedDescendant(thisGrp) || !grp.isEmpty()) continue;
            bPassCondition = true;
            break;
        }
        if (!bPassCondition && thisGrp.getSuppressWhenNoNestedDetails() && thisGrp.getNumberChildren() == 2) {
            bPassCondition = ((AbstractMDXSet)thisGrp.getChild(1)).isEmpty();
        }
        if (!bPassCondition) {
            this.traceNodeCondition(false, "This CogMDXGroup does not need to be empty.", trace);
            return false;
        }
        IXQEQueryNode[] descendantNests = thisGrp.getDescendantsOfType(1026, false);
        if (descendantNests.length > 0) {
            this.traceNodeCondition(false, "This CogMDXGroup is still nesting at least one CogMDXNest node.", trace);
            return false;
        }
        if (node.getDescendantsOfType(1004, false).length > 0) {
            this.traceNodeCondition(false, "The target node has a descendant which is a set alias definition.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This CogMDXGroup needs to be empty.", trace);
        return true;
    }
}

