/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.mdx.parser.ASTMDXStatement;
import com.cognos.xqe.ast.mdx.parser.ASTUserDefinedProperty;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.ast.olap.MDXDimensionProperties;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXParserUtility;
import com.cognos.xqe.ast.olap.util.MetadatatoMDXMemberPropertyTranslator;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.XMdxIdentifier;
import com.cognos.xqe.runtree.olap.mdx.XMdxProperty;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;
import java.util.ArrayList;

public final class AddMemberPropertiesToMDXQueryForLOLAP
extends ProviderTransformation {
    public AddMemberPropertiesToMDXQueryForLOLAP() {
        super(new String[]{"EB", "TM", "TMR"});
        this.mName = "Adds the list of member properties that are referenced in the query to the MDXQuery for LOLAP providers.";
        this.mPassNumbers = new int[]{33};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        IXQEQueryNode[] baseProperties = mdxQuery.getDescendantsOfType(1025, false);
        MDXDimensionProperties dimProps = new MDXDimensionProperties();
        String dataSource = mdxQuery.getDataSourceType();
        for (IXQEQueryNode bp : baseProperties) {
            BaseProperty baseProperty = (BaseProperty)bp;
            String propertyName = null;
            IQueryItem queryItemProperty = null;
            if (baseProperty.getPropertyMetadata() != null) {
                IQueryItem property;
                if (dataSource.equals("BW") && (property = baseProperty.getPropertyMetadata()).isBusinessKey()) continue;
                queryItemProperty = baseProperty.getPropertyMetadata();
                propertyName = MetadatatoMDXMemberPropertyTranslator.translate(queryItemProperty.getUniqueName());
                if (propertyName == null) {
                    propertyName = queryItemProperty.getUniqueName();
                    queryItemProperty = null;
                } else if (!propertyName.equals("PPDS_KEY") && queryItemProperty.getUniqueName().equals(propertyName)) {
                    propertyName = null;
                } else {
                    queryItemProperty = null;
                }
            } else if (baseProperty.getPropertyName() != null) {
                propertyName = baseProperty.getPropertyName();
            }
            if (propertyName != null) {
                dimProps.addMemberProperty(propertyName);
                continue;
            }
            if (queryItemProperty != null) {
                dimProps.addCustomMemberProperty(queryItemProperty);
                continue;
            }
            node.throwInternalError("Unable get name of property, Property id=" + node.getId());
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ");
        dimProps.writeFormattedText(buffer);
        buffer.append(" ON AXIS(0) FROM [FAKE_CUBE]");
        ASTMDXStatement astStatement = (ASTMDXStatement)MDXParserUtility.parseMDX(buffer.toString(), environment, MDXParserUtility.ParseType.STATEMENT);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode[] propertyNodes = astStatement.getDescendantsOfType(701044, false);
        ArrayList<XMdxProperty> propertyList = new ArrayList<XMdxProperty>();
        for (IXQEQueryNode child : propertyNodes) {
            XMdxProperty xProperty = (XMdxProperty)nodeFactory.createNode(501091);
            xProperty.setParserNode((MDXQueryNode)child);
            propertyList.add(xProperty);
            IXQEQueryNode propertyNode = child.getChild(0);
            if (!(propertyNode instanceof ASTUserDefinedProperty)) continue;
            IXQEQueryNode[] propertyChildren = propertyNode.getChildren();
            for (int j = 0; j < propertyChildren.length; ++j) {
                XMdxIdentifier xNode = (XMdxIdentifier)nodeFactory.createNode(501092);
                xNode.setParserNode((MDXQueryNode)propertyChildren[j]);
                xProperty.addChild(xNode);
            }
        }
        mdxQuery.setRequiredProperties(propertyList);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (mdxQuery.getRequiredProperties() != null) {
            this.traceQueryCondition(false, "Adding properties have already been added.", trace);
            return false;
        }
        if (!super.passesNodeCondition(node, environment)) {
            this.traceQueryCondition(false, "Adding properties to the dimension line is only required by EB, TM1, or BW.", trace);
            return false;
        }
        if (!mdxQuery.getUseLocalQueryProcessing()) {
            this.traceQueryCondition(false, "Adding properties to the dimension line is only required when using LOLAP.", trace);
            return false;
        }
        this.traceQueryCondition(true, "Properties need to be set.", trace);
        return true;
    }
}

