/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public abstract class ProviderTransformation
extends Transformation {
    private String[] dataSourceTypes;

    public ProviderTransformation(String dsType) {
        this.dataSourceTypes = new String[]{dsType};
    }

    public ProviderTransformation(String[] dsTypes) {
        this.dataSourceTypes = dsTypes;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = this.getMDXQueryFromNode(node);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The provider type can not be determined.", trace);
            return false;
        }
        if (mdxQuery.isRelationalStyleQuery()) {
            this.traceNodeCondition(false, "OLAP transformation will not be applied to Relational style query.", trace);
            return false;
        }
        String queryDataSource = mdxQuery.getDataSourceType();
        for (int i = 0; i < this.dataSourceTypes.length; ++i) {
            if (!queryDataSource.equals(this.dataSourceTypes[i])) continue;
            return true;
        }
        if ((trace.getTraceLevel() & 4) != 0) {
            this.traceNodeCondition(false, this.dataSourceMessage(), trace);
        }
        return false;
    }

    private String dataSourceMessage() {
        StringBuilder sb = new StringBuilder("The provider type is not ");
        if (this.dataSourceTypes.length < 0) {
            sb.append("set");
            return sb.toString();
        }
        sb.append(this.dataSourceTypes[0]);
        for (int i = 1; i < this.dataSourceTypes.length; ++i) {
            sb.append(" or ");
            sb.append(DataSourceTypeEnum.getProviderName(this.dataSourceTypes[i]));
        }
        sb.append(".");
        return sb.toString();
    }

    protected String[] getDataSourceTypes() {
        return this.dataSourceTypes;
    }

    protected MDXQuery getMDXQueryFromNode(IXQEQueryNode node) {
        MDXQuery mdxQuery = node.getType() == 1002 ? (MDXQuery)node : (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            mdxQuery = (MDXQuery)node.getFirstDescendantOfTypeOrdered(1002, false);
        }
        return mdxQuery;
    }
}

