/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;
import com.cognos.xqe.util.LinkedStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReOrderCalcMemberNamedSet
extends ProviderTransformation {
    private int[] defTypes = new int[]{1005, 1003};
    private int[] refTypes = new int[]{1013, 1014};

    public ReOrderCalcMemberNamedSet() {
        super(new String[]{"EB", "DO", "BW", "TMR"});
        this.mName = "Re order calculated member and named set definisions in MDXQuery.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1002};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (mdxQuery.isCalcMemberNamedSetOrdered()) {
            this.traceNodeCondition(false, "The calculated member or named set in the MDX is already reordered.", trace);
            return false;
        }
        IXQEQueryNode[] cmANDnmChildren = mdxQuery.getChildrenOfTypes(this.defTypes);
        int length = cmANDnmChildren.length;
        if (length == 0) {
            this.traceNodeCondition(false, "No calculated member or named set in the MDX.", trace);
            return false;
        }
        boolean hasRef = false;
        for (int i = 0; !hasRef && i < length; ++i) {
            if (cmANDnmChildren[i].getDescendantsOfTypes(this.refTypes, false).length == 0) continue;
            hasRef = true;
        }
        if (!hasRef) {
            this.traceNodeCondition(false, "The calculated member or named set in the MDX is not refering to another calculated member or named set.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Need to re-order the calculated member or named set for SAP. ", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        LinkedStack<IXQEQueryNode> queryNodehelper1 = new LinkedStack<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> queryNodehelper2 = new ArrayList<IXQEQueryNode>();
        IXQEQueryNode[] cmANDnmChildren = mdxQuery.getChildrenOfTypes(this.defTypes);
        int length = cmANDnmChildren.length;
        int i = 0;
        for (i = 0; i < length; ++i) {
            if (cmANDnmChildren[i].getDescendantsOfTypes(this.refTypes, false).length == 0) {
                queryNodehelper1.push(cmANDnmChildren[i]);
                continue;
            }
            queryNodehelper2.add(cmANDnmChildren[i]);
        }
        Iterator it = queryNodehelper2.iterator();
        while (it.hasNext()) {
            AbstractMDXNode calcDef = (AbstractMDXNode)it.next();
            List<AbstractMDXNode> refNodes = calcDef.getDescendantsOfTypes(this.refTypes, false, false, false, false, false);
            boolean addNode = true;
            Iterator<AbstractMDXNode> itRef = refNodes.iterator();
            while (addNode && itRef.hasNext()) {
                AbstractMDXNode calcRefDef = itRef.next();
                if (calcRefDef.getType() == 1013) {
                    if (!queryNodehelper2.contains(((MDXCalculatedMemberReference)calcRefDef).getDefinition())) continue;
                    addNode = false;
                    continue;
                }
                if (!queryNodehelper2.contains(((MDXNamedSetReference)calcRefDef).getDefinition())) continue;
                addNode = false;
            }
            if (!addNode) continue;
            queryNodehelper1.push(calcDef);
            queryNodehelper2.remove(calcDef);
            it = queryNodehelper2.iterator();
        }
        if (!queryNodehelper2.isEmpty()) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidChildNode, node.getNodeTypeName());
        }
        for (i = 0; i < length; ++i) {
            cmANDnmChildren[i].getParent().detachChild(cmANDnmChildren[i]);
        }
        while (!queryNodehelper1.empty()) {
            mdxQuery.addChild((AbstractMDXNode)queryNodehelper1.pop(), 0);
        }
        mdxQuery.setCalcMemberNamedSetOrdered();
    }
}

