/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXDimensionProperties;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.IAlias;
import com.cognos.xqe.metadata.IAliasEntry;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.EssbaseTransformation;
import com.cognos.xqe.util.LocaleConverter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public final class SetEssbaseDefaultDimensionProperties
extends EssbaseTransformation {
    public SetEssbaseDefaultDimensionProperties() {
        this.mName = "Set Essbase default dimension properties on axis";
        this.mPassNumbers = new int[]{2, 46};
        this.mTypes = new int[]{1006};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXEdge edge = (MDXEdge)node;
        MDXDimensionProperties props = edge.getDimensionProperties();
        String[] propsToCheckForRemove = new String[]{"PARENT_UNIQUE_NAME", "PARENT_LEVEL"};
        for (int i = 0; i < propsToCheckForRemove.length; ++i) {
            if (!props.containsMemberProperty(propsToCheckForRemove[i])) continue;
            this.traceNodeCondition(true, propsToCheckForRemove[i] + " property is set and should be removed.", trace);
            return true;
        }
        String[] propsToCheckForAdd = new String[]{"ANCESTOR_NAMES", "LEVEL_NUMBER", "MEMBER_ALIAS"};
        for (int i = 0; i < propsToCheckForAdd.length; ++i) {
            if (props.containsMemberProperty(propsToCheckForAdd[i])) continue;
            this.traceNodeCondition(true, propsToCheckForAdd[i] + " property not set.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Default properties already set.", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge edge = (MDXEdge)node;
        String[] propsToCheckForRemove = new String[]{"PARENT_UNIQUE_NAME", "PARENT_LEVEL"};
        for (int i = 0; i < propsToCheckForRemove.length; ++i) {
            edge.removeMemberProperty(propsToCheckForRemove[i]);
        }
        String[] propsToAdd = new String[]{"ANCESTOR_NAMES", "LEVEL_NUMBER", "GEN_NUMBER", "MEMBER_ALIAS"};
        for (int i = 0; i < propsToAdd.length; ++i) {
            edge.addMemberProperty(propsToAdd[i]);
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXFromCube fromCube = mdxQuery.getMDXFrom();
        IAlias alias = (IAlias)fromCube.getAlias();
        if (alias != null) {
            List<IAliasEntry> aliasentries = alias.getAliasEntries();
            Iterator<IAliasEntry> it = aliasentries.iterator();
            String runLocaleString = null;
            String runLocaleLanguage = null;
            Element connectionElement = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getConnectionElement();
            if (connectionElement != null) {
                Element runLocaleElement = null;
                runLocaleElement = connectionElement.element("runLocale");
                if (runLocaleElement != null) {
                    runLocaleString = runLocaleElement.attributeValue("value");
                    int i = runLocaleString.indexOf(45);
                    runLocaleLanguage = i >= 0 ? runLocaleString.substring(0, i) : runLocaleString;
                }
            }
            if (runLocaleString == null) {
                runLocaleString = LocaleConverter.getLanguage(((RequestEnvironment)environment.getRequestEnvironment()).getRunLocale());
            }
            ArrayList<IAliasEntry> aliasTable = new ArrayList<IAliasEntry>();
            IAliasEntry entry = null;
            boolean notFound = true;
            while (notFound && it.hasNext()) {
                entry = it.next();
                if (!entry.getKey().equalsIgnoreCase(runLocaleLanguage)) continue;
                notFound = false;
                aliasTable.add(entry);
                mdxQuery.setAliasTable(aliasTable);
            }
            if (!notFound) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("[");
                buffer.append(entry.getValue());
                buffer.append("]");
                edge.addMemberProperty(buffer.toString());
            }
        }
    }
}

