/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.EssbaseTransformation;

public final class SetEssbaseMemberPropertyFormat
extends EssbaseTransformation {
    public SetEssbaseMemberPropertyFormat() {
        this.mName = "Set Essbase property format";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1016, 1070};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ((AbstractMDXNode)node).setUseEssbasePropertyFormat(true);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        boolean isFunction = false;
        if (node.getType() == 1070) {
            MDXComparisonOperator cNode = (MDXComparisonOperator)node;
            int operatorType = cNode.getOperatorType();
            switch (operatorType) {
                case 7: 
                case 8: 
                case 9: {
                    isFunction = true;
                    break;
                }
                default: {
                    isFunction = false;
                }
            }
        }
        if (isFunction) {
            this.traceNodeCondition(false, "Essbase property format is not required.", trace);
            return false;
        }
        boolean bUseEssbasePropertyFormat = ((AbstractMDXNode)node).isUseEssbasePropertyFormat();
        if (bUseEssbasePropertyFormat) {
            this.traceNodeCondition(false, "Essbase property format already applied.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Essbase property need to use different format.", trace);
        return true;
    }
}

