/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase.direct;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.direct.EssbaseDirectTransformation;

public class WrapAscendantsInSetIncludeSelf
extends EssbaseDirectTransformation {
    public static final String APPLIED = "isApplied";

    public WrapAscendantsInSetIncludeSelf() {
        this.mName = "Wrap Ascendants Function into a Set Function.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1045};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode mdxSetNode = factory.createNode(1039);
        IXQEQueryNode member = node.getChild(0);
        mdxSetNode.addChild(member);
        node.insertParent(mdxSetNode);
        node.setPropertyValue(APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        boolean isApplied = false;
        Boolean propValue = (Boolean)node.getPropertyValue(APPLIED);
        if (propValue != null) {
            isApplied = propValue;
        }
        if (isApplied) {
            this.traceNodeCondition(status, "The Ascendants function has already been resolved.", trace);
            return false;
        }
        this.traceNodeCondition(status, "The Ascendants function exists.", trace);
        return status;
    }
}

