/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.finalization.RollbackMDXSetAlias;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class RollbackMDXSetAliasOnSlicerCalculation
extends ProviderTransformation {
    private static final String[] PROVIDER_TYPES = new String[]{"M12", "M14", "M16", "M17", "M19", "MAZ", "X8"};

    public RollbackMDXSetAliasOnSlicerCalculation() {
        super(PROVIDER_TYPES);
        this.mName = "Rollback Set Alias on Slicer Calculation for MSAS.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1015};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RollbackMDXSetAlias.rollbackSetAliasNode((MDXSetAliasReference)node, environment);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXSetAliasReference aliasRef = (MDXSetAliasReference)node;
        IXQEQueryNode calcDef = aliasRef.getAncestorOfType(1005);
        if (calcDef != null && this.setAliasUsedInSlicerCalculation((MDXCalculatedMemberDefinition)calcDef)) {
            this.traceNodeCondition(true, "The target set alias node is used on slicer calculation.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The set alias is not used under slicer calculation", trace);
        return false;
    }

    private boolean setAliasUsedInSlicerCalculation(MDXCalculatedMemberDefinition calcDef) {
        List<MDXCalculatedMemberReference> calcRefs = calcDef.getCalcMemberRefs();
        for (IXQEQueryNode iXQEQueryNode : calcRefs) {
            IXQEQueryNode parentCalcDef = iXQEQueryNode.getAncestorOfType(1005);
            if (null != parentCalcDef && this.setAliasUsedInSlicerCalculation((MDXCalculatedMemberDefinition)parentCalcDef)) {
                return true;
            }
            if (iXQEQueryNode.getAncestorOfType(1008) == null) continue;
            return true;
        }
        return false;
    }
}

