/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;

public final class TransformComparisonOperators
extends ProviderTransformation {
    static final String[] PROVIDER_TYPES = new String[]{"YK", "M8", "M12", "M14", "M16", "M17", "M19", "XO", "MAZ", "X8", "XI", "RO", "X5"};

    public TransformComparisonOperators() {
        super(PROVIDER_TYPES);
        this.mName = "Transform comparison operators for MSAS";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1070};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXComparisonOperator fn = (MDXComparisonOperator)node;
        fn.setMDXSyntax(1);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXComparisonOperator compNode = (MDXComparisonOperator)node;
        int fnType = compNode.getOperatorType();
        if (fnType != 9 && fnType != 7 && fnType != 8) {
            this.traceNodeCondition(false, "This comparison operator does not need to be transformed.", trace);
            return false;
        }
        if (compNode.getMDXSyntax() != 0) {
            this.traceNodeCondition(false, "This comparison operator has already been transformed.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This comparison operator function must be transformed.", trace);
        return true;
    }
}

