/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2000;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;

public final class RenameProperties
extends ProviderTransformation {
    public RenameProperties() {
        super(new String[]{"XO"});
        this.mName = "Rename properties for MSAS";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1016};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        BaseProperty prop = (BaseProperty)node.getChild(0);
        IQueryItem property = prop.getPropertyMetadata();
        if (property != null) {
            String propName = property.getUniqueName();
            if (RoleTypeEnum.isRSAPIKeyword(propName)) {
                propName = RoleTypeEnum.rsapiToMdx(propName);
            }
            if (propName.equals("MEMBER_CAPTION")) {
                prop.setPropertyValue("externalName", "CAPTION");
            }
            if (propName.equals("MEMBER_KEY")) {
                prop.setPropertyValue("externalName", "KEY");
            }
            if (propName.equals("MEMBER_UNIQUE_NAME")) {
                prop.setPropertyValue("externalName", "UNIQUENAME");
            }
        } else {
            String propName = prop.getPropertyName();
            if (propName.equals("MEMBER_CAPTION")) {
                prop.setPropertyName("CAPTION");
            }
            if (propName.equals("MEMBER_KEY")) {
                prop.setPropertyName("KEY");
            }
            if (propName.equals("MEMBER_UNIQUE_NAME")) {
                prop.setPropertyName("UNIQUENAME");
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        node.throwOnInvalidChildCategories();
        if (node.getChild(0).getType() != 1025) {
            this.traceNodeCondition(false, "The property is not a base property.", trace);
            return false;
        }
        String propName = ((BaseProperty)node.getChild(0)).getMDXName();
        if (!(propName.equals("MEMBER_CAPTION") || propName.equals("MEMBER_KEY") || propName.equals("MEMBER_UNIQUE_NAME"))) {
            this.traceNodeCondition(false, "The property is not one of the properties that must be renamed.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Property must be renamed.", trace);
        return true;
    }
}

