/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2005;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class ConvertDimensionLineTupleToSet
extends YukonTransformation {
    public ConvertDimensionLineTupleToSet() {
        this.mName = "Convert Dimension Line Tuple To Set.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXTuple mdxTuple = (MDXTuple)node.getChild(0);
        IXQEQueryNode[] children = mdxTuple.getChildren();
        ArrayList<MDXSet> sets = new ArrayList<MDXSet>();
        Set<IHierarchy> refMultHiers = ((AbstractMDXNode)node.getAncestorOfType(1002)).getReferencedMultipleHierarchies();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        Set<IDimension> dimsRefdOnEdges = mdxQuery.getReferencedDimensionsOnEdges();
        for (IXQEQueryNode child : children) {
            if (child.getType() != 1013) {
                sets.add(MDXBuilder.buildMDXSetExpr((IXQENodeFactory)factory, (AbstractMDXMember)child));
                continue;
            }
            ArrayList<AbstractMDXSet> currChildSets = new ArrayList<AbstractMDXSet>();
            MDXCalculatedMemberReference cmRef = (MDXCalculatedMemberReference)child;
            boolean allowAutoExistsInSlicer = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getBooleanProperty("queryPlanning.AllowAutoexistsWithSlicer[@enabled]", false);
            if (!allowAutoExistsInSlicer && refMultHiers.contains(cmRef.getHierarchy())) {
                sets.add(MDXBuilder.buildMDXSetExpr((IXQENodeFactory)factory, cmRef));
                continue;
            }
            ArrayList<MDXCalculatedMemberDefinition> nestedDefs = new ArrayList<MDXCalculatedMemberDefinition>();
            boolean canBeReplaced = ConvertDimensionLineTupleToSet.collectNestedMDXCalculatedMemberDefinitions(cmRef.getDefinition(), nestedDefs);
            if (canBeReplaced) {
                ArrayList<IHierarchy> hierarchies = new ArrayList<IHierarchy>();
                ArrayList<IDimension> dimensions = new ArrayList<IDimension>();
                Iterator it = nestedDefs.iterator();
                while (it.hasNext() && canBeReplaced) {
                    MDXCalculatedMemberDefinition cmDef = (MDXCalculatedMemberDefinition)it.next();
                    MDXHierInfo hierInfo = ((AbstractMDXSet)cmDef.getChild(0).getChild(0)).getHierarchyInfo();
                    if (hierInfo.getNumProjectedHierarchies() != 1) {
                        canBeReplaced = false;
                        break;
                    }
                    IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
                    if (hierarchies.contains(hierarchy)) {
                        canBeReplaced = false;
                        break;
                    }
                    if (!allowAutoExistsInSlicer && refMultHiers.contains(hierarchy)) {
                        canBeReplaced = false;
                        break;
                    }
                    if (!allowAutoExistsInSlicer && dimensions.contains(hierarchy.getDimension())) {
                        canBeReplaced = false;
                        break;
                    }
                    hierarchies.add(hierarchy);
                    dimensions.add(hierarchy.getDimension());
                    AbstractMDXSet set = (AbstractMDXSet)cmDef.getChild(0).getChild(0);
                    currChildSets.add((AbstractMDXSet)factory.deepCopyNode(set));
                }
                if (!allowAutoExistsInSlicer) {
                    Iterator dimIt = dimensions.iterator();
                    while (dimIt.hasNext()) {
                        if (!dimsRefdOnEdges.contains(dimIt.next())) continue;
                        canBeReplaced = false;
                    }
                }
            }
            if (!canBeReplaced) {
                sets.add(MDXBuilder.buildMDXSetExpr((IXQENodeFactory)factory, cmRef));
                continue;
            }
            sets.addAll(currChildSets);
        }
        if (sets.size() > 1) {
            IXQEQueryNode[] setNodes = new IXQEQueryNode[sets.size()];
            sets.toArray(setNodes);
            MDXCrossjoin mdxCrossjoin = MDXBuilder.buildMDXCrossjoinExpr(factory, setNodes);
            node.exchangeChildNode(mdxTuple, mdxCrossjoin);
        } else {
            node.exchangeChildNode(mdxTuple, (IXQEQueryNode)sets.get(0));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder traceMasg = new StringBuilder();
        boolean result = ConvertDimensionLineTupleToSet.nodeCondition(node, traceMasg);
        this.traceNodeCondition(result, traceMasg.toString(), trace);
        return result;
    }

    public static boolean nodeCondition(IXQEQueryNode node, StringBuilder traceMasg) {
        if (!node.validateChildCategories()) {
            if (traceMasg != null) {
                traceMasg.append("The child nodes of the target MDXDimensionLine node are invalid.");
            }
            return false;
        }
        if (node.getChild(0).getType() != 1069) {
            if (traceMasg != null) {
                traceMasg.append("The first child of the target MDXDimensionLine node is not an MDXTuple node.");
            }
            return false;
        }
        MDXTuple mdxTuple = (MDXTuple)node.getChild(0);
        if (!mdxTuple.validateChildCategories()) {
            if (traceMasg != null) {
                traceMasg.append("The child nodes of the MDXTuple child of the target MDXDimensionLine node are invalid.");
            }
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        Set<IDimension> dimsRefdOnEdges = mdxQuery.getReferencedDimensionsOnEdges();
        Set<IHierarchy> refMultHiers = mdxQuery.getReferencedMultipleHierarchies();
        for (IXQEQueryNode child : mdxTuple.getChildren()) {
            if (child.getType() != 1013) {
                if (traceMasg == null) continue;
                traceMasg.append("The child node is not a calculated member reference.");
                continue;
            }
            MDXCalculatedMemberReference cmRef = (MDXCalculatedMemberReference)child;
            ArrayList<MDXCalculatedMemberDefinition> nestedDefs = new ArrayList<MDXCalculatedMemberDefinition>();
            if (!ConvertDimensionLineTupleToSet.collectNestedMDXCalculatedMemberDefinitions(cmRef.getDefinition(), nestedDefs)) {
                if (traceMasg == null) continue;
                traceMasg.append("The MDXCalculatedMemberDefinition associated with the MDXCalculatedMemberReference on ");
                traceMasg.append("the MDXDimension line does not match the required pattern.");
                continue;
            }
            boolean canBeReplaced = true;
            ArrayList<IHierarchy> hierarchies = new ArrayList<IHierarchy>();
            ArrayList<IDimension> dimensions = new ArrayList<IDimension>();
            Iterator it = nestedDefs.iterator();
            boolean allowAutoExistsInSlicer = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getBooleanProperty("queryPlanning.AllowAutoexistsWithSlicer[@enabled]", false);
            while (it.hasNext()) {
                MDXCalculatedMemberDefinition cmDef = (MDXCalculatedMemberDefinition)it.next();
                MDXHierInfo hierInfo = ((AbstractMDXSet)cmDef.getChild(0).getChild(0)).getHierarchyInfo();
                if (hierInfo.getNumProjectedHierarchies() != 1) {
                    if (traceMasg != null) {
                        traceMasg.append("One of the aggregation sets in the nested MDXCalculatedMemberDefinition");
                        traceMasg.append(" chain does not project a single hierarchy.");
                    }
                    canBeReplaced = false;
                    break;
                }
                IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
                if (hierarchies.contains(hierarchy)) {
                    if (traceMasg != null) {
                        traceMasg.append("The same hierarchy is projected by two or more aggregation sets");
                        traceMasg.append(" in the nested MDXCalculatedMemberDefinition chain.");
                    }
                    canBeReplaced = false;
                    break;
                }
                if (!allowAutoExistsInSlicer && refMultHiers.contains(cmRef.getHierarchy())) {
                    if (traceMasg != null) {
                        traceMasg.append("The hierarchy belongs to a dimension with multiple referenced hierarchies.");
                    }
                    canBeReplaced = false;
                    break;
                }
                if (!allowAutoExistsInSlicer && dimensions.contains(hierarchy.getDimension())) {
                    if (traceMasg != null) {
                        traceMasg.append("Two or more aggregation sets in the nested MDXCalculatedMemberDefinition chain ");
                        traceMasg.append("project hierarchies from the same dimension.");
                    }
                    canBeReplaced = false;
                    break;
                }
                hierarchies.add(hierarchy);
                dimensions.add(hierarchy.getDimension());
            }
            for (IDimension dimension : dimensions) {
                if (allowAutoExistsInSlicer || !dimsRefdOnEdges.contains(dimension)) continue;
                if (traceMasg != null) {
                    traceMasg.append("One of the aggregation sets projects a hierarchy that belongs to a dimension that ");
                    traceMasg.append("is referenced on one or more of the edges in the associated MDXQuery.");
                }
                canBeReplaced = false;
            }
            if (!canBeReplaced) continue;
            if (traceMasg != null) {
                traceMasg.append("The transformation can be applied to the target node.");
            }
            return true;
        }
        return false;
    }

    private static boolean collectNestedMDXCalculatedMemberDefinitions(MDXCalculatedMemberDefinition def, List<MDXCalculatedMemberDefinition> nestedDefs) {
        if (!def.validateChildCategories()) {
            return false;
        }
        if (def.getChild(0).getType() != 1060 || ((MDXSummaryFunction)def.getChild(0)).getSummaryType() != MDXSummaryFunctionTypeEnum.AGGREGATE) {
            return false;
        }
        IXQEQueryNode aggr = def.getChild(0);
        if (!aggr.validateChildCategories()) {
            return false;
        }
        MDXCalculatedMemberDefinition nestedDef = null;
        if (aggr.getNumberChildren() == 2) {
            if (aggr.getChild(1).getType() != 1059) {
                return false;
            }
            IXQEQueryNode mdxValue = aggr.getChild(1);
            if (!mdxValue.validateChildCategories()) {
                return false;
            }
            IXQEQueryNode mdxTuple = mdxValue.getChild(0);
            if (!mdxTuple.validateChildCategories() || mdxTuple.getNumberChildren() != 1 || mdxTuple.getChild(0).getType() != 1013) {
                return false;
            }
            MDXCalculatedMemberReference cmRef = (MDXCalculatedMemberReference)mdxTuple.getChild(0);
            nestedDef = cmRef.getDefinition();
        }
        nestedDefs.add(def);
        if (nestedDef != null) {
            return ConvertDimensionLineTupleToSet.collectNestedMDXCalculatedMemberDefinitions(nestedDef, nestedDefs);
        }
        return true;
    }
}

