/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2005.multihier;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class AddDefaultMemberToGenerateExpressions
extends YukonTransformation {
    public AddDefaultMemberToGenerateExpressions() {
        this.mName = "Add Multiple Hierarchy Implicit Member To Context.";
        this.mPassNumbers = new int[]{44};
        this.mTypes = new int[]{1057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        List<IHierarchy> hierarchies = this.getRequiredHierarchies(node);
        AbstractMDXSet newSet = (AbstractMDXSet)node.getChild(0).detach();
        for (IHierarchy hier : hierarchies) {
            newSet = MDXBuilder.buildMDXCrossjoinExpr(factory, newSet, MDXBuilder.buildMDXSetExpr((IXQENodeFactory)factory, MDXBuilder.buildMDXDefaultMemberExpr((IXQENodeFactory)factory, hier)));
        }
        node.addChild(newSet, 0);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode calcDef = node.getAncestorOfType(1005);
        if (calcDef == null) {
            this.traceNodeCondition(false, "The node does not have an ancestor MDXCalculatedMemberDefinition node.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        Set<IHierarchy> hierarchies = mdxQuery.getReferencedMultipleHierarchies();
        if (hierarchies.size() == 0) {
            this.traceNodeCondition(false, "The ancestor MDXQuery node does not project multiple hierarchies from the same dimension.", trace);
            return false;
        }
        if (this.getRequiredHierarchies(node).isEmpty()) {
            this.traceNodeCondition(false, "The second set does not project multiple hierarchies from the same dimension is first set.", trace);
            return false;
        }
        this.traceNodeCondition(true, "MDXDefaultMember nodes must be added to the first set of the MDXGenerate.", trace);
        return true;
    }

    private List<IHierarchy> getRequiredHierarchies(IXQEQueryNode node) {
        ArrayList<IHierarchy> result = new ArrayList<IHierarchy>();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        Set<IHierarchy> hierarchies = mdxQuery.getReferencedMultipleHierarchies();
        if (hierarchies.size() == 0) {
            return result;
        }
        AbstractMDXSet firstSet = (AbstractMDXSet)node.getChild(0);
        AbstractMDXSet secondSet = (AbstractMDXSet)node.getChild(1);
        Iterator<IHierarchy> it = hierarchies.iterator();
        MDXHierInfo firstSetHierInfo = firstSet.getHierarchyInfo();
        MDXHierInfo secondSetHierInfo = secondSet.getHierarchyInfo();
        while (it.hasNext()) {
            IHierarchy hierarchy = it.next();
            if (!secondSet.isContextDependent(hierarchy)) continue;
            for (IHierarchy nextHier : secondSetHierInfo.getProjectedHierarchies()) {
                if (nextHier.equals(hierarchy) || !nextHier.getDimension().equals(hierarchy.getDimension()) || firstSetHierInfo.projectsHierarchy(nextHier) || result.contains(nextHier)) continue;
                result.add(nextHier);
            }
        }
        return result;
    }
}

