/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2005.multihier;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeYukonAddMemberToSummarySet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;
import java.util.List;

public final class AddMemberToSummarySet
extends YukonTransformation {
    private int[] implicitContextRequired = new int[]{1042, 1041, 1053, 1058};

    public AddMemberToSummarySet() {
        this.mName = "Add Multiple Hierarchy Member To Context Of Summary Set.";
        this.mPassNumbers = new int[]{44};
        this.mTypes = new int[]{1143};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQueryNode;
        XQENodeFactory factory = environment.getNodeFactory();
        AbstractMDXMember member = (AbstractMDXMember)node.getChild(1);
        AbstractMDXSet summarySet = (AbstractMDXSet)node.getChild(0);
        MDXHierInfo summarySetHierInfo = summarySet.getHierarchyInfo();
        if (summarySetHierInfo.projectsHierarchy(member.getHierarchy()) || !summarySetHierInfo.projectsSameDimensionDiffHierarchy(member.getHierarchy())) {
            node.getParent().exchangeChildNode(node, summarySet);
            return;
        }
        boolean allowAutoExistsInSlicer = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getBooleanProperty("queryPlanning.AllowAutoexistsWithSlicer[@enabled]", false);
        if (allowAutoExistsInSlicer && (mdxQueryNode = (MDXQuery)node.getAncestorOfType(1002)).getDimensionLine() != null && member.getType() == 1076 && mdxQueryNode.getDimensionLine().getHierarchyInfo().projectsHierarchy(member.getHierarchy())) {
            boolean msasCURRENTMEMBERError = false;
            MDXCalculatedMemberDefinition summaryCalcmDef = (MDXCalculatedMemberDefinition)summarySet.getAncestorOfType(1005);
            if (summaryCalcmDef != null) {
                List<MDXCalculatedMemberReference> calcMemberRefs = summaryCalcmDef.getCalcMemberRefs();
                for (MDXCalculatedMemberReference calcMemberRef : calcMemberRefs) {
                    MDXEdge mdxEdge = (MDXEdge)calcMemberRef.getAncestorOfType(1006);
                    if (mdxEdge == null) {
                        msasCURRENTMEMBERError = false;
                        continue;
                    }
                    msasCURRENTMEMBERError = true;
                    break;
                }
            }
            if (msasCURRENTMEMBERError) {
                node.getParent().exchangeChildNode(node, summarySet);
                return;
            }
        }
        TNodeYukonAddMemberToSummarySet tNode = (TNodeYukonAddMemberToSummarySet)node;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXHierInfo hierInfo = tNode.getOriginalMDXHierInfo();
        hierInfo.removeHierarchiesFromOtherDimensions(member.getHierarchy().getDimension());
        if (member.getType() != 1013 && !AddMemberToSummarySet.containsNestedHierarchy(mdxQuery, hierInfo, member.getHierarchy()) && (node.getParent().getType() != 1087 && node.getParent().getType() != 1060 && node.getParent().getType() != 1100 || node.getChild(0).getType() != 1053)) {
            IXQEQueryNode crossjoin = factory.createNode(1030);
            IXQEQueryNode set = factory.createNode(1039);
            node.getChild(1).move(set);
            crossjoin.addChild(set);
            node.getChild(0).insertParent(crossjoin);
            this.removeExists(set, member);
        } else {
            member.getParent().detachChild(1);
            this.addMemberToNestedSet(factory, (AbstractMDXSet)tNode.getChild(0), member);
        }
        node.extract();
    }

    private void addMemberToNestedSet(IXQENodeFactory factory, AbstractMDXSet set, AbstractMDXMember member) {
        boolean memberAdded = false;
        switch (set.getType()) {
            case 1041: 
            case 1042: 
            case 1053: 
            case 1058: {
                this.addMemberToNestedSet(factory, (AbstractMDXSet)set.getChild(0), member);
                return;
            }
            case 1032: 
            case 1038: 
            case 1039: {
                int i;
                for (i = 0; i < set.getNumberChildren(); ++i) {
                    if (!set.getChild(i).isOfCategory(1021) || set.getChild(i).getDescendantsOfTypes(this.implicitContextRequired, false).length <= 0) continue;
                    memberAdded = true;
                    break;
                }
                if (!memberAdded) break;
                for (i = 0; i < set.getNumberChildren(); ++i) {
                    member = (AbstractMDXMember)factory.deepCopyNode(member);
                    this.addMemberToNestedSet(factory, (AbstractMDXSet)set.getChild(i), member);
                }
                return;
            }
            case 1030: {
                AbstractMDXSet firstSet = (AbstractMDXSet)set.getChild(0);
                AbstractMDXSet secondSet = (AbstractMDXSet)set.getChild(1);
                MDXHierInfo firstSetHierInfo = firstSet.getHierarchyInfo();
                MDXHierInfo secondSetHierInfo = secondSet.getHierarchyInfo();
                if (firstSet.getDescendantsOfTypes(this.implicitContextRequired, false).length > 0 && firstSetHierInfo.projectsSameDimensionDiffHierarchy(member.getHierarchy())) {
                    if (secondSet.getDescendantsOfTypes(this.implicitContextRequired, true).length > 0 && secondSetHierInfo.projectsSameDimensionDiffHierarchy(member.getHierarchy())) {
                        if (secondSet.isOfCategory(1030)) {
                            this.addMemberToNestedSet(factory, secondSet, member);
                            return;
                        }
                        set.throwInternalError("Error resolving hierarchy relationships.");
                    }
                    this.addMemberToNestedSet(factory, firstSet, member);
                    return;
                }
                if (secondSet.getDescendantsOfTypes(this.implicitContextRequired, true).length <= 0 || !secondSetHierInfo.projectsSameDimensionDiffHierarchy(member.getHierarchy())) break;
                this.addMemberToNestedSet(factory, secondSet, member);
                return;
            }
            case 1057: {
                AbstractMDXSet firstSet = (AbstractMDXSet)set.getChild(0);
                AbstractMDXSet secondSet = (AbstractMDXSet)set.getChild(1);
                MDXHierInfo firstSetHierInfo = firstSet.getHierarchyInfo();
                MDXHierInfo secondSetHierInfo = secondSet.getHierarchyInfo();
                if (firstSetHierInfo.projectsSameDimensionDiffHierarchy(member.getHierarchy())) {
                    this.addMemberToNestedSet(factory, firstSet, member);
                }
                if (secondSetHierInfo.projectsSameDimensionDiffHierarchy(member.getHierarchy())) {
                    this.addMemberToNestedSet(factory, secondSet, (AbstractMDXMember)factory.deepCopyNode(member));
                }
                return;
            }
            case 1033: 
            case 1037: {
                for (int i = 0; i < set.getNumberChildren(); ++i) {
                    if (!set.getChild(i).isOfCategory(1021) || set.getChild(i).getDescendantsOfTypes(this.implicitContextRequired, false).length <= 0) continue;
                    if (memberAdded) {
                        member = (AbstractMDXMember)factory.deepCopyNode(member);
                    }
                    this.addMemberToNestedSet(factory, (AbstractMDXSet)set.getChild(i), member);
                    memberAdded = true;
                }
                if (!memberAdded) break;
                return;
            }
        }
        IXQEQueryNode crossjoin = factory.createNode(1030);
        IXQEQueryNode mdxSet = factory.createNode(1039);
        mdxSet.addChild(member);
        crossjoin.addChild(mdxSet);
        set.insertParent(crossjoin);
        this.removeExists(set, member);
    }

    private void removeExists(IXQEQueryNode set, AbstractMDXMember member) {
        while (set.getType() == 1128 || set.getType() == 1030) {
            if (set.getType() == 1030) {
                set = set.getChild(1);
                continue;
            }
            if (set.getChild(1).getType() == 1039 && member.isSameExpression(set.getChild(1).getChild(0), false)) {
                set.detachSecondChild();
                set.extract();
                return;
            }
            set = set.getChild(0);
        }
    }

    public static boolean containsNestedHierarchy(MDXQuery mdxQuery, MDXHierInfo setHierInfo, IHierarchy hierarchy) {
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            MDXEdge edge = edges[i];
            MDXHierInfo edgeHierInfo = edge.getHierarchyInfo();
            if (!edgeHierInfo.projectsHierarchy(hierarchy)) continue;
            if (!edgeHierInfo.projectsHierarchies(setHierInfo)) {
                return false;
            }
            List<IHierarchy> hierarchies = edgeHierInfo.getProjectedHierarchies();
            for (IHierarchy hier : hierarchies) {
                if (hier == hierarchy) {
                    return true;
                }
                if (!setHierInfo.projectsHierarchy(hier)) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        AbstractMDXMember member;
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        if (node.getDescendantsOfType(1143, false).length > 0) {
            this.traceNodeCondition(false, "There are unresolved descendant TNodeYukonAddMemberToSummarySet nodes.", trace);
            return false;
        }
        AbstractMDXSet summarySet = (AbstractMDXSet)node.getChild(0);
        MDXHierInfo hierInfo = summarySet.getHierarchyInfo();
        if (hierInfo.projectsHierarchy((member = (AbstractMDXMember)node.getChild(1)).getHierarchy()) || !hierInfo.projectsSameDimensionDiffHierarchy(member.getHierarchy())) {
            StringBuilder sb = new StringBuilder("Invalid TNode.  Hierarchy of AbstractMDXMember is already projected in the");
            sb.append(" set expression or the same dimension is not projected in the expression.");
            if (summarySet.getDescendantsOfType(1015, false).length == 0) {
                node.throwInternalError(sb.toString());
            }
        }
        this.traceNodeCondition(true, "The node has valid categories and can be applied.", trace);
        return true;
    }
}

