/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2005.multihier;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.HashMap;
import java.util.Map;

public final class CreateGenerateSetForValueExpression
extends YukonTransformation {
    private int[] checkValueExpressions = new int[]{1041, 1053, 1058};

    public CreateGenerateSetForValueExpression() {
        this.mName = "Add Multiple Hierarchy Implicit Member To Context.";
        this.mPassNumbers = new int[]{44};
        this.mTypes = this.checkValueExpressions;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXSet contextSet = this.getContextSet(node, environment);
        IXQEQueryNode generateSet = factory.createNode(1057);
        node.insertParent(generateSet);
        generateSet.addChild(contextSet, 0);
    }

    private MDXSet getContextSet(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXTuple contextTuple = (MDXTuple)factory.createNode(1069);
        HashMap<IHierarchy, BaseMember> contextMemberMap = this.getContextMemberMap(node);
        if (contextMemberMap.isEmpty()) {
            return null;
        }
        for (Map.Entry<IHierarchy, BaseMember> entry : contextMemberMap.entrySet()) {
            contextTuple.addChild(MDXBuilder.buildMDXCurrentMemberExpr(factory, entry.getKey()));
            contextTuple.addChild(factory.deepCopyNode(entry.getValue()));
        }
        return MDXBuilder.buildMDXSetExpr((IXQENodeFactory)factory, contextTuple);
    }

    private HashMap<IHierarchy, BaseMember> getContextMemberMap(IXQEQueryNode node) {
        HashMap<IHierarchy, BaseMember> contextMemberMap = new HashMap<IHierarchy, BaseMember>();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode calcDef = node.getAncestorOfType(1005);
        IXQEQueryNode valueExpression = this.getValueExpressionChild(node);
        if (valueExpression == null) {
            return contextMemberMap;
        }
        MDXHierInfo contextInfo = ((AbstractMDXNode)node).getContextHierarchyInfo((AbstractMDXNode)calcDef);
        IXQEQueryNode[] members = valueExpression.getDescendantsOfType(1067, false);
        for (int i = 0; i < members.length; ++i) {
            BaseMember member = (BaseMember)members[i];
            if (contextInfo.projectsHierarchy(member.getHierarchy())) continue;
            MDXHierInfo setHierInfo = ((AbstractMDXSet)node).getHierarchyInfo();
            for (IHierarchy hierarchy : setHierInfo.getProjectedHierarchies()) {
                if (hierarchy.equals(member.getHierarchy()) || !hierarchy.getDimension().equals(member.getHierarchy().getDimension())) continue;
                MDXEdge[] edges = mdxQuery.getEdges();
                for (int j = 0; j < edges.length; ++j) {
                    MDXEdge edge = edges[j];
                    MDXHierInfo edgeHierInfo = edge.getHierarchyInfo();
                    if (!edgeHierInfo.projectsHierarchy(hierarchy) || edgeHierInfo.projectsHierarchy(member.getHierarchy())) continue;
                    contextMemberMap.put(hierarchy, member);
                }
            }
        }
        return contextMemberMap;
    }

    private IXQEQueryNode getValueExpressionChild(IXQEQueryNode node) {
        IXQEQueryNode[] children = node.getChildren();
        IXQEQueryNode valueExpression = null;
        for (int i = 0; i < children.length; ++i) {
            if (!((AbstractMDXNode)children[i]).isValueExpressionOperand() || ((AbstractMDXNode)children[i]).getHierarchyInfo().getNumProjectedHierarchies() <= 0) continue;
            valueExpression = children[i];
            break;
        }
        return valueExpression;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode calcDef = node.getAncestorOfType(1005);
        if (calcDef == null) {
            this.traceNodeCondition(false, "The node does not have an ancestor MDXCalculatedMemberDefinition node.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.getReferencedMultipleHierarchies().size() == 0) {
            this.traceNodeCondition(false, "The ancestor MDXQuery node does not project multiple hierarchies from the same dimension.", trace);
            return false;
        }
        IXQEQueryNode valueExpression = this.getValueExpressionChild(node);
        if (valueExpression == null) {
            this.traceNodeCondition(false, "The node does not have a value expression child.", trace);
            return false;
        }
        if (!this.getContextMemberMap(node).isEmpty()) {
            this.traceNodeCondition(true, "A parent MDXGenerate node is required to avoid autoexists from affecting the set.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The node does not need a parent MDXGenerate node created.", trace);
        return false;
    }
}

