/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2005.multihier;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.TNodeYukonImplicitMembers;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class CreateImplicitMembers
extends YukonTransformation {
    public CreateImplicitMembers() {
        this.mName = "Create Implicit Members For Multiple Hierarchies.";
        this.mPassNumbers = new int[]{40};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        TNodeYukonImplicitMembers tNode = (TNodeYukonImplicitMembers)factory.createNode(1142);
        MDXQuery mdxQuery = (MDXQuery)node;
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        MDXHierInfo hierarchies = this.collectHierarchies(mdxQuery);
        Set<IHierarchy> refMultipleHierarchies = mdxQuery.getReferencedMultipleHierarchies();
        Iterator<IHierarchy> it = hierarchies.getProjectedHierarchies().iterator();
        node.addChild(tNode);
        Set<IDimension> dimsForMultiHier = this.collectDimensions(mdxQuery, refMultipleHierarchies);
        while (it.hasNext()) {
            IHierarchy hierarchy = it.next();
            for (IDimension dimensionOnEdge : dimsForMultiHier) {
                if (!dimensionOnEdge.equals(hierarchy.getDimension())) continue;
                IXQEQueryNode member = null;
                if (dimLine != null) {
                    List<IXQEQueryNode> tupleMembers = dimLine.getDescendantsOfCategory(1022, false);
                    for (IXQEQueryNode n : tupleMembers) {
                        AbstractMDXMember calcRef = (AbstractMDXMember)n;
                        if (calcRef.getHierarchy() != hierarchy) continue;
                        if (calcRef.getType() == 1013) {
                            ((MDXCalculatedMemberReference)calcRef).setCopyDefinition(false);
                        }
                        member = factory.deepCopyNode(calcRef);
                        tNode.setContainsSlicerCalcMember(true);
                    }
                }
                if (member == null) {
                    member = MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy);
                }
                tNode.addChild(member);
            }
        }
    }

    Set<IDimension> collectDimensions(MDXQuery mdxQuery, Set<IHierarchy> hierarchies) {
        Set<IDimension> dimsRefdOnEdges = mdxQuery.getReferencedDimensionsOnEdges();
        HashSet<IDimension> dimsForMultiHier = new HashSet<IDimension>();
        Iterator<IHierarchy> it = hierarchies.iterator();
        while (it.hasNext()) {
            IDimension dimension = it.next().getDimension();
            for (IDimension dimensionOnEdge : dimsRefdOnEdges) {
                if (!dimensionOnEdge.equals(dimension)) continue;
                dimsForMultiHier.add(dimension);
            }
        }
        return dimsForMultiHier;
    }

    MDXHierInfo collectHierarchies(MDXQuery mdxQuery) {
        MDXHierInfo hierInfo = mdxQuery.getHierarchyInfo();
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        MDXHierInfo dimLineHierInfo = null;
        dimLineHierInfo = dimLine != null ? dimLine.getHierarchyInfo() : new MDXHierInfo();
        Set<IHierarchy> refHierarchies = mdxQuery.getReferencedMultipleHierarchies();
        for (IHierarchy hierarchy : refHierarchies) {
            if (hierInfo.projectsHierarchy(hierarchy) || dimLineHierInfo.projectsHierarchy(hierarchy)) continue;
            hierInfo.appendProjectedHierarchy(hierarchy);
        }
        hierInfo.unionHierInfo(dimLineHierInfo);
        return hierInfo;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        IXQEQueryNode[] implicitMembersNode = node.getDescendantsOfType(1142, false);
        if (mdxQuery.isYukonHierarchyRelationshipCompensationApplied() || implicitMembersNode.length > 0) {
            this.traceNodeCondition(false, "The transformation has already been applied.", trace);
            return false;
        }
        Set<IHierarchy> hierarchies = mdxQuery.getReferencedMultipleHierarchies();
        if (hierarchies.isEmpty()) {
            this.traceNodeCondition(false, "The MDXQuery node does not contain multiple hierarchies from the same dimension.", trace);
            return false;
        }
        Set<IDimension> dimsForMultiHier = this.collectDimensions(mdxQuery, hierarchies);
        if (dimsForMultiHier.isEmpty()) {
            this.traceNodeCondition(false, "The dimension for the multiple hierarchy is not projected on the edge.", trace);
            return false;
        }
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        if (dimLine != null && dimLine.isOfCategory(1069)) {
            MDXTuple dimLineTuple = (MDXTuple)dimLine.getChild(0);
            dimLineTuple.throwOnInvalidChildCategories();
            for (int i = 0; i < dimLineTuple.getNumberChildren(); ++i) {
                AbstractMDXMember member = (AbstractMDXMember)dimLine.getChild(i);
                if (member.isOfCategory(1013) || !hierarchies.contains(member.getHierarchy())) continue;
                this.traceQueryCondition(false, "The dimension line contains AbstractMDXMember's from multiple hierarchies that are not of type MDXCalculatedMemberReferece.", trace);
                return false;
            }
        }
        this.traceNodeCondition(true, "The MDXQuery node contains multiple hierarchies from the same dimension.", trace);
        return true;
    }
}

