/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXScalarFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;

public class ConvertRoundupRounddownToCeilFloor
extends SAPBWTransformation {
    public ConvertRoundupRounddownToCeilFloor() {
        this.mName = "Convert roundup/rounddown function to ceil/floor function.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1144};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        String functionName = ((CogMDXScalarFunction)node).getMDXTextName();
        if (!functionName.equals("ROUNDUP") && !functionName.equals("ROUNDDOWN")) {
            this.traceNodeCondition(false, "No conversion needed for MDX Scalar Function. ", trace);
            return false;
        }
        this.traceNodeCondition(true, "The MDX Scalar function needs to be converted.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String functionName = ((CogMDXScalarFunction)node).getMDXTextName();
        if (functionName.equals("ROUNDUP")) {
            ((CogMDXScalarFunction)node).setOperatorMDX("CEIL");
        } else {
            ((CogMDXScalarFunction)node).setOperatorMDX("FLOOR");
        }
    }
}

