/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSAPVariables;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQueryFactory;
import com.cognos.xqe.runtree.olap.querytemplates.MemberQueryBasedOnLevel;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;
import java.util.ArrayList;
import java.util.List;

public final class SetRSAPIDataItemLabelForSAPReplacementVariable
extends SAPBWTransformation {
    public SetRSAPIDataItemLabelForSAPReplacementVariable() {
        this.mName = "Set RSAPIDataItem label for SAP replacement variable.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{401005};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIDataset dataset = (RSAPIDataset)node;
        IXQEQueryNode[] fromCubes = dataset.getDescendantsOfType(1007, false);
        ICube cube = ((MDXFromCube)fromCubes[0]).getCube();
        MemberQueryBasedOnLevel customQuery = (MemberQueryBasedOnLevel)CustomQueryFactory.createCustomQuery("MemberQueryBasedOnLevel", cube);
        MDXQuery mdxQuery = (MDXQuery)node.getFirstDescendantOfTypeOrdered(1002, false);
        customQuery.setLevelName(cube.getMeasuresHierarchy().getUniqueName());
        MDXSAPVariables sapVariables = (MDXSAPVariables)mdxQuery.getPropertyValue("sapVariables");
        String strSAPvars = null;
        if (sapVariables != null && sapVariables.getSAPVariableCount() > 0) {
            strSAPvars = "SAP VARIABLES " + sapVariables.toString();
        }
        customQuery.setVariables(strSAPvars);
        IHybridResultSet queryResult = null;
        XDataContext dataContext = ((ExecutionEnvironment)environment.getExecutionEnvironment()).pushDataContext();
        try {
            queryResult = customQuery.execute(dataContext);
            this.setLabelsWithMDXResult(queryResult, node);
        }
        finally {
            ((ExecutionEnvironment)environment.getExecutionEnvironment()).popDataContext(dataContext);
            if (null != queryResult) {
                queryResult.release();
            }
        }
        mdxQuery.setSAPReplacementVariableIsSet();
        environment.setTreeHasBeenModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLabelsWithMDXResult(IHybridResultSet hybridResultSet, IXQEQueryNode node) {
        XIterator xIt = null;
        ArrayList<IMember> members = new ArrayList<IMember>();
        try {
            if (hybridResultSet.getNumAxes() > 0) {
                xIt = hybridResultSet.getAxisIterator(0);
                ITuple tuple = (ITuple)xIt.next();
                while (tuple != null) {
                    IMember member = tuple.getMember(0);
                    members.add(member);
                    tuple = (ITuple)xIt.next();
                }
            }
        }
        finally {
            if (null != xIt) {
                xIt.release();
            }
        }
        RSAPIDataset dataset = (RSAPIDataset)node;
        IXQEQueryNode[] fromCubes = dataset.getDescendantsOfType(1007, false);
        ICube cube = ((MDXFromCube)fromCubes[0]).getCube();
        RSAPIEdge[] edges = dataset.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            RSAPIEdgeRowset[] edgeRowsets = edges[i].getRowsets();
            for (int j = 0; j < edgeRowsets.length; ++j) {
                RSAPIDataItem[] dataItems = edgeRowsets[j].getDataItems();
                if (dataItems.length == 0) {
                    this.setRSAPIDataItemLabel(edgeRowsets[j].getRefDataItem(), cube, members);
                    continue;
                }
                for (int k = 0; k < dataItems.length; ++k) {
                    this.setRSAPIDataItemLabel(dataItems[k], cube, members);
                }
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getFirstDescendantOfTypeOrdered(1002, false);
        if (!mdxQuery.isListReport()) {
            this.traceQueryCondition(false, "The MDXQuery is xtab. The label won't be used in RSAPIDataItem.", trace);
            return false;
        }
        IXQEQueryNode[] fromCubes = mdxQuery.getDescendantsOfType(1007, false);
        if (fromCubes == null || fromCubes.length == 0) {
            this.traceQueryCondition(false, "There is no valid MDXFromCube in the query.", trace);
            return false;
        }
        if (fromCubes.length != 1) {
            this.traceQueryCondition(false, "Either a constent query or a multi-Cube query.", trace);
            return false;
        }
        ICube cube = ((MDXFromCube)fromCubes[0]).getCube();
        if (!cube.hasSAPReplacementVariable()) {
            this.traceQueryCondition(false, "There is no sap replacement variable in the query.", trace);
            return false;
        }
        if (mdxQuery.isSAPReplacementVariableSet()) {
            this.traceQueryCondition(false, "The SAP replacement varialbe is already set.", trace);
            return false;
        }
        RSAPIDataset dataset = (RSAPIDataset)node;
        StringBuilder msg = new StringBuilder();
        boolean status = false;
        RSAPIEdge[] edges = dataset.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            RSAPIEdgeRowset[] edgeRowsets = edges[i].getRowsets();
            for (int j = 0; j < edgeRowsets.length; ++j) {
                RSAPIDataItem[] dataItems = edgeRowsets[j].getDataItems();
                if (dataItems.length == 0) {
                    boolean bl = status = edgeRowsets[j].getRefDataItem() != null && this.checkRSAPIDataItemCondition(edgeRowsets[j].getRefDataItem(), cube, msg);
                    if (!status) continue;
                    this.traceNodeCondition(status, msg.toString(), trace);
                    return status;
                }
                for (int k = 0; k < dataItems.length; ++k) {
                    status = this.checkRSAPIDataItemCondition(dataItems[k], cube, msg);
                    if (!status) continue;
                    this.traceNodeCondition(status, msg.toString(), trace);
                    return status;
                }
            }
        }
        this.traceQueryCondition(status, "There is no sap replacement varialbe in the query.", trace);
        return status;
    }

    private boolean checkRSAPIDataItemCondition(RSAPIDataItem rsapiItem, ICube cube, StringBuilder msg) {
        IMetadata iMetadata = rsapiItem.getModelReference();
        IHierarchy hierarchy = MetadataUtil.getHierarchy(iMetadata);
        if (hierarchy == null) {
            return false;
        }
        IDimension dimension = hierarchy.getDimension();
        if (cube.isReplacementVariableUsed(dimension) && hierarchy.getDimension().isMeasuresDimension()) {
            msg.append("Found a measure with replacement variable.");
            return true;
        }
        return false;
    }

    private void setRSAPIDataItemLabel(RSAPIDataItem rsapiItem, ICube cube, List<IMember> members) {
        IMetadata iMetadata = rsapiItem.getModelReference();
        IHierarchy hierarchy = MetadataUtil.getHierarchy(iMetadata);
        if (hierarchy == null) {
            return;
        }
        IDimension dimension = hierarchy.getDimension();
        if (cube.isReplacementVariableUsed(dimension) && dimension.isMeasuresDimension()) {
            IMember iMember = (IMember)iMetadata;
            if (cube.isReplacementVariableUsed(hierarchy.getDimension())) {
                for (IMember hybridResultMember : members) {
                    if (!hybridResultMember.getUniqueName().equals(iMember.getUniqueName())) continue;
                    rsapiItem.setLabel(hybridResultMember.getCaption());
                }
            }
        }
    }
}

