/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXScalarFunction;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;

public final class UseLOLAPForScalarFunctions
extends SAPBWTransformation {
    public UseLOLAPForScalarFunctions() {
        this.mName = "Use LOLAP for scalar functions.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1144};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        mdxQuery.setUseLocalQueryProcessing(Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        String functionName = ((CogMDXScalarFunction)node).getMDXTextName();
        if (!functionName.equals("ROUND") && !functionName.equals("POWER")) {
            this.traceNodeCondition(false, "The MDX Scalar function is supported by SAP.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.getUseLocalQueryProcessing() || mdxQuery.getPropertyValue("forceLocalQueryProcessing") != null) {
            this.traceNodeCondition(false, "The property is already set.", trace);
            return false;
        }
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (!capabilities.isSupported("v5.useLOLAPForFunctions")) {
            this.traceQueryCondition(false, "Configuration does not use LOLAP for such pattern.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The MDX Scalar function is not supported by SAP. The query needs to be processed by LOLAP", trace);
        return true;
    }
}

