/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;

public final class UseLOLAPForStringDeclarations
extends SAPBWTransformation {
    public UseLOLAPForStringDeclarations() {
        this.mName = "Validate calculated member definition for SAP.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1005};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        mdxQuery.setUseLocalQueryProcessing(Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] nodes;
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.getUseLocalQueryProcessing() || mdxQuery.getPropertyValue("forceLocalQueryProcessing") != null) {
            this.traceNodeCondition(false, "The property is already set.", trace);
            return false;
        }
        int nChildrenOfString = 0;
        for (IXQEQueryNode child : nodes = ((MDXCalculatedMemberDefinition)node).getChildrenOfCategory(1061)) {
            if (!((AbstractMDXValueExpression)child).isString()) continue;
            ++nChildrenOfString;
        }
        if (nChildrenOfString == 0) {
            this.traceQueryCondition(false, "Calculated member definition is valid.", trace);
            return false;
        }
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (!capabilities.isSupported("v5.useLOLAPForFunctions")) {
            this.traceQueryCondition(false, "Configuration does not use LOLAP for such pattern.", trace);
            return false;
        }
        this.traceQueryCondition(true, "Calculated member definition is NOT valid for SAP. Can not define a calculated member as a string.  Using local query processing.", trace);
        return true;
    }
}

